% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertPedigree.R
\name{compute_parent_adjacency}
\alias{compute_parent_adjacency}
\title{Compute Parent Adjacency Matrix with Multiple Approaches}
\usage{
compute_parent_adjacency(
  ped,
  component,
  adjacency_method = "indexed",
  saveable,
  resume,
  save_path,
  verbose,
  lastComputed,
  nr,
  checkpoint_files,
  update_rate,
  parList,
  lens,
  save_rate_parlist,
  ...
)
}
\arguments{
\item{ped}{a pedigree dataset.  Needs ID, momID, and dadID columns}

\item{component}{character.  Which component of the pedigree to return.  See Details.}

\item{adjacency_method}{character. The method to use for computing the adjacency matrix.  Options are "loop" or "indexed"}

\item{saveable}{logical. If TRUE, save the intermediate results to disk}

\item{resume}{logical. If TRUE, resume from a checkpoint}

\item{save_path}{character. The path to save the checkpoint files}

\item{verbose}{logical.  If TRUE, print progress through stages of algorithm}

\item{lastComputed}{the last computed index}

\item{nr}{the number of rows in the pedigree dataset}

\item{checkpoint_files}{a list of checkpoint files}

\item{update_rate}{numeric. The rate at which to print progress}

\item{parList}{a list of parent-child relationships}

\item{lens}{a vector of the lengths of the parent-child relationships}

\item{save_rate_parlist}{numeric. The rate at which to save the intermediate results by parent list. If NULL, defaults to save_rate*1000}

\item{...}{additional arguments to be passed to \code{\link{ped2com}}}
}
\description{
Compute Parent Adjacency Matrix with Multiple Approaches
}
\details{
The algorithms and methodologies used in this function are further discussed and exemplified in the vignette titled "examplePedigreeFunctions". For more advanced scenarios and detailed explanations, consult this vignette.
}
