% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCuPloth.R
\name{CCuPloth}
\alias{CCuPloth}
\title{Plots for the Hazard and Survival Funcion Estimates}
\usage{
CCuPloth(M, new_obs = NULL, type.h = "segment", qn = 0.5,
  confidence = 0.95, summary = FALSE)
}
\arguments{
\item{M}{tibble. Contains the output generated by \code{CuMRres}.}

\item{new_obs}{tibble. Contains the covariate information for new observations.}

\item{type.h}{character. "segment"= use segments to plot hazard rates,
"line" = link hazard rates by a line}

\item{qn}{Numeric. Quantile for Tao (cure time) that should be visualized on the plot.}

\item{confidence}{Numeric. Confidence level.}

\item{summary}{Logical. If \code{TRUE}, a summary for the hazard and survival
functions is returned as a tibble.}
}
\value{
\item{SUM.h}{Numeric tibble. Summary for the mean, median, and a
\code{confint / 100} confidence interval for each segment of the hazard
function. If \code{summary = TRUE}} \item{SUM.S}{Numeric tibble. Summary for
the mean, median, and a \code{confint / 100} confidence interval for each
segment of the survival function. If \code{summary = TRUE}}
}
\description{
Plots the resulting hazard function and the survival function
estimates defined by the bayesian semiparametric cure rate model with 
an unknown threshold (Nieto-Barajas & Yin, 2008).
}
\details{
This function returns estimators plots for the hazard rate as it is computed
by \link{CCuMRes} and the cure time (quantile of Tao specified by the user)
together with credible intervals. Additionally, it plots the survival function 
and the cure proportion estimates with their corresponding credible intervals.
}
\examples{



## Simulations may be time intensive. Be patient.

## Example 1
# data(BMTKleinbook)
    # res <- CCuMRes(BMTKleinbook, covs.x = c("tTransplant","hodgkin","karnofsky","waiting"),
    #                covs.y = c("tTransplant","hodgkin","karnofsky","waiting"),
    #                        type.t = 2, K = 72, length = 30,
    #                        alpha = rep(2,72), beta = rep(2,72), c.r = rep(50, 71), type.c = 2,
    #                        var.delta.str = .1, var.theta.str = 1,
    #                        var.delta.ini = 100, var.theta.ini = 100,
    #                        iterations = 100, burn.in = 10, thinning = 1)
    # 
    # CCuPloth(res, type.h = "segment",qn=.5, summary = T)
    # 
    # new_obs <- tibble(tTransplant=c(0,0,0,0),
    #                       hodgkin=c(0,1,0,1),
    #                       karnofsky=c(90,90,60,60),
    #                       waiting=c(36,36,36,36)
    # )
    # 
    # ind <- CCuPloth(res, new_obs, qn = .5)
    # ind



}
\references{
- Nieto-Barajas, L. E. (2003). Discrete time Markov gamma
processes and time dependent covariates in survival analysis. \emph{Bulletin
of the International Statistical Institute 54th Session}. Berlin. (CD-ROM).

-Nieto-Barajas, L. E., & Yin, G. (2008). Bayesian semiparametric cure rate
model with an unknown threshold. \emph{Scandinavian Journal of Statistics},
\strong{35(3)}, 540-556. https://doi.org/10.1111/j.1467-9469.2007.00589.x
}
\seealso{
\link{CCuMRes},
}
