% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare_estimate.default.R
\name{summary.ggm_compare_estimate}
\alias{summary.ggm_compare_estimate}
\title{Summary method for \code{ggm_compare_estimate} objects}
\usage{
\method{summary}{ggm_compare_estimate}(object, col_names = TRUE, cred = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{ggm_compare_estimate}.}

\item{col_names}{Logical. Should the summary include the column names (default is \code{TRUE})?
Setting to \code{FALSE} includes the column numbers (e.g., \code{1--2}).}

\item{cred}{Numeric. The credible interval width for summarizing the posterior
distributions (defaults to 0.95; must be between 0 and 1).}

\item{...}{Currently ignored.}
}
\value{
A list containing the summarized posterior distributions.
}
\description{
Summarize the posterior distribution of each partial correlation
difference with the posterior mean and standard deviation.
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes
# data
Y <- bfi

# males and females
Ymale <- subset(Y, gender == 1,
                select = -c(gender,
                            education))[,1:5]

Yfemale <- subset(Y, gender == 2,
                  select = -c(gender,
                              education))[,1:5]

# fit model
fit <- ggm_compare_estimate(Ymale,  Yfemale,
                            type = "ordinal",
                            iter = 250,
                            prior_sd = 0.25,
                            progress = FALSE)

summary(fit)
}
}
\seealso{
\code{\link{ggm_compare_estimate}}
}
