% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FINAL_FUNCTIONS_f_test.R
\name{f.test.BFF}
\alias{f.test.BFF}
\title{f.test.BFF}
\usage{
f.test.BFF(
  f_stat,
  n,
  df1,
  df2,
  savename = NULL,
  r = 1,
  tau2 = NULL,
  save = TRUE,
  xlab = NULL,
  ylab = NULL,
  main = NULL
)
}
\arguments{
\item{f_stat}{F statistic}

\item{n}{sample size}

\item{df1}{first degree of freedom}

\item{df2}{first degree of freedom}

\item{savename}{optional, filename for saving the pdf of the final plot}

\item{r}{r value}

\item{tau2}{tau2 values}

\item{save}{should a copy of the plot be saved?}

\item{xlab}{optional, x label for plot}

\item{ylab}{optional, y label for plot}

\item{main}{optional, main label for plot}
}
\value{
Returns Bayes factor function results
 \tabular{ll}{
   \code{BFF} \tab Bayes Factor Function values \cr
   \tab \cr
   \code{effect_size} \tab Effect sizes tested (seq(0, 1, by = 0.01)) \cr
   \tab \cr
   \code{BFF_max_RMSE} \tab Maximum BFF value \cr
   \tab \cr
   \code{max_RMSE} \tab Effect size that maximizes BFF\cr
   \tab \cr
   \code{tau2} \tab tau^2 values tested\cr
}
}
\description{
f.test.BFF constructs BFFs based on the F test. BFFs depend on hyperparameters r and tau^2 which determine the shape and scale of the prior distributions which define the alternative hypotheses.
By setting r > 1, we use higher-order moments for replicated studies. Fractional moments are set with r > 1 and r not an integer.
All results are on the log scale.
Plot saved to working directory unless a full path is specified in the 'savename' variable of the function.
}
\examples{
fBFF = f.test.BFF(f_stat = 2.5, n = 50, df1 = 20, df2 = 48, save = FALSE)
BFF = f.test.BFF(f_stat = 2.5, n = 50, df1 = 20, df2 = 48, save = FALSE, tau2 = 0.4)
f.test.BFF(f_stat = 2.5, n = 50, df1 = 20, df2 = 48, r = 2, save = FALSE)
f.test.BFF(f_stat = 2.5, n = 50, df1 = 20, df2 = 48, r = 2.5, save = FALSE)
fBFF$BFF_max_RMSE  # maximum BFF value
fBFF$max_RMSE      # effect size which maximizes the BFF value

}
