% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDirectProduct.R
\name{getDirectProduct}
\alias{getDirectProduct}
\title{Get the direct product of BE identifiers}
\usage{
getDirectProduct(
  ids,
  sources = NULL,
  process = c("is_expressed_as", "is_translated_in", "codes_for"),
  canonical = NA
)
}
\arguments{
\item{ids}{list of origin identifiers}

\item{sources}{a character vector corresponding to the possible origin ID
sources. If NULL (default), all sources are considered}

\item{process}{the production process among:
"is_expressed_as", "is_translated_in", "codes_for".}

\item{canonical}{If TRUE returns only canonical production process.
If FALSE returns only non-canonical production processes.
If NA (default) canonical information is taken into account.}
}
\value{
a data.frame with the following columns:
\itemize{
\item \strong{origin}: the origin BE identifiers
\item \strong{osource}: the origin database
\item \strong{product}: the product BE identifiers
\item \strong{psource}: the production database
\item \strong{canonical}: whether the production process is canonical or not
}

The process is also returned as an attribute of the data.frame.
}
\description{
The product is directly taken as provided by the original database.
This function does not return indirect relationships.
}
\examples{
\dontrun{
oriId <- c("10", "100")
res <- getDirectProduct(
   ids=oriId,
   source="EntrezGene",
   process="is_expressed_as",
   canonical=NA
)
attr(res, "process")
}

}
\seealso{
\link{getDirectOrigin}, \link{convBeIds}
}
