% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceplane.plot.R
\name{ceplane.plot.bcea}
\alias{ceplane.plot.bcea}
\alias{ceplane.plot}
\title{Cost-effectiveness Plane Plot}
\usage{
\method{ceplane.plot}{bcea}(
  he,
  comparison = NULL,
  wtp = 25000,
  pos = c(0, 1),
  graph = c("base", "ggplot2", "plotly"),
  ...
)

ceplane.plot(he, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{comparison}{Selects the comparator, in case of more than two
interventions being analysed. Default as \code{NULL} plots all the
comparisons together. Any subset of the possible comparisons can be selected
(e.g., \code{comparison = c(1,3)} or \code{comparison = 2}).}

\item{wtp}{The value of the willingness to pay parameter. Not used if
\code{graph = "base"} for multiple comparisons.}

\item{pos}{Parameter to set the position of the legend; for a single
comparison plot, the ICER legend position. Can be given in form of a string
\code{(bottom|top)(right|left)} for base graphics and
\code{bottom|top|left|right} for ggplot2. It can be a two-elements vector,
which specifies the relative position on the x and y axis respectively, or
alternatively it can be in form of a logical variable, with \code{FALSE}
indicating to use the default position and \code{TRUE} to place it on the
bottom of the plot. Default value is \code{c(1,1)}, that is the topright
corner inside the plot area.}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-) match the two options \code{"base"} or
\code{"ggplot2"}. Default value is \code{"base"}.}

\item{...}{Additional arguments}
}
\value{
If \code{graph = "ggplot2"} a ggplot object, or if \code{graph = "plotly"} 
  a plotly object containing the requested plot. Nothing is returned when
  \code{graph = "base"}, the default.
   
  Grey dots show the simulated values for the joint
  distribution of the effectiveness and cost differentials. The larger red
  dot shows the ICER and the grey area identifies the sustainability area,
  i.e. the part of the plan for which the simulated values are below the
  willingness to pay threshold. The proportion of points in the sustainability
  area effectively represents the CEAC for a given value of the willingness to
  pay. If the comparators are more than 2 and no pairwise comparison is
  specified, all scatterplots are graphed using different colours.
}
\description{
Produces a scatter plot of the cost-effectiveness plane,
together with the sustainability area, as a function of
the selected willingness to pay threshold.
}
\details{
In the plotly version, point_colors, ICER_colors and area_color can also
be specified as rgba colours using either the \code{\link[plotly]{toRGB}}
function or a rgba colour string, e.g. \code{'rgba(1, 1, 1, 1)'}.
}
\examples{
## create the bcea object for the smoking cessation example
data(Smoking)

m <- bcea(e, c, ref = 4, Kmax = 500, interventions = treats)

## produce the base plot
ceplane.plot(m, wtp = 200, graph = "base")

## select only one comparator
ceplane.plot(m, wtp = 200, graph = "base", comparison = 3)

## use ggplot2
if (requireNamespace("ggplot2")) {
   ceplane.plot(m, wtp = 200, pos = "right", ICER_size = 2, graph = "ggplot2")
}

## plotly
ceplane.plot(m, wtp = 200, graph = "plotly")
ceplane.plot(m, wtp = 200, comparison = 1, graph = "plotly")
 
}
\references{
Baio, G., Dawid, A. P. (2011). Probabilistic Sensitivity Analysis in Health Economics.
Statistical Methods in Medical Research. doi:10.1177/0962280211419832.

Baio G. (2012). Bayesian Methods in Health Economics. CRC/Chapman Hall, London.
}
\seealso{
\code{\link{bcea}},
         \code{\link{ceplane_plot_graph}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\concept{"Health economic evaluation" "Cost Effectiveness Plane"}
\keyword{hplot}
