% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceac.plot.R
\name{ceac.plot.bcea}
\alias{ceac.plot.bcea}
\alias{ceac.plot}
\title{Cost-Effectiveness Acceptability Curve (CEAC) Plot}
\usage{
\method{ceac.plot}{bcea}(
  he,
  comparison = NULL,
  pos = c(1, 0),
  graph = c("base", "ggplot2", "plotly"),
  ...
)

ceac.plot(he, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{comparison}{Selects the comparator, in case of more than two
interventions being analysed. Default as NULL plots all the comparisons
together. Any subset of the possible comparisons can be selected (e.g.,
\code{comparison=c(1,3)} or \code{comparison=2}).}

\item{pos}{Parameter to set the position of the legend (only relevant for
multiple interventions, ie more than 2 interventions being compared).
Can be given in form
of a string \code{(bottom|top)(right|left)} for base graphics and
\code{bottom|top|left|right} for ggplot2. It can be a two-elements vector,
which specifies the relative position on the x and y axis respectively, or
alternatively it can be in form of a logical variable, with \code{FALSE}
indicating to use the default position and \code{TRUE} to place it on the
bottom of the plot.}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-)match the three options \code{"base"},
\code{"ggplot2"} or \code{"plotly"}. Default value is \code{"base"}.}

\item{...}{If \code{graph = "ggplot2"} and a named theme object is supplied,
 it will be added to the ggplot object. Additional arguments:
\itemize{
 \item \code{line_colors}: specifies the line colour(s) - all graph types.
 \item \code{line_types}: specifies the line type(s) as lty numeric values - all graph types.
 \item \code{area_include}: logical, include area under the CEAC curves - plotly only.
 \item \code{area_color}: specifies the AUC colour - plotly only.}}
}
\value{
\item{ceac}{If \code{graph = "ggplot2"} a ggplot object, or if \code{graph = "plotly"} 
  a plotly object containing the requested plot. Nothing is returned when \code{graph = "base"},
  the default.} The function produces a plot of the
  cost-effectiveness acceptability curve against the discrete grid of possible
  values for the willingness to pay parameter. Values of the CEAC closer to 1
  indicate that uncertainty in the cost-effectiveness of the reference
  intervention is very low. Similarly, values of the CEAC closer to 0 indicate
  that uncertainty in the cost-effectiveness of the comparator is very low.
}
\description{
Produces a plot of the Cost-Effectiveness Acceptability Curve (CEAC) against
the willingness to pay threshold.
}
\details{
The CEAC estimates the probability of cost-effectiveness, with respect to a
given willingness to pay threshold. The CEAC is used mainly to evaluate the
uncertainty associated with the decision-making process, since it enables the
quantification of the preference of the compared interventions, defined in terms
of difference in utilities.
Formally, the CEAC is defined as:

\deqn{\textrm{CEAC} = P(\textrm{IB}(\theta) > 0)}
  
If the net benefit function is used as utility function, the definition can be
re-written as

\deqn{\textrm{CEAC} = P(k \cdot \Delta_e - \Delta_c > 0)}

effectively depending on the willingness to pay value \eqn{k}.
}
\examples{
data("Vaccine")
he <- BCEA::bcea(e, c)
ceac.plot(he)

ceac.plot(he, graph = "base")
ceac.plot(he, graph = "ggplot2")
ceac.plot(he, graph = "plotly")

ceac.plot(he, graph = "ggplot2",
          title = "my title",
          line = list(colors = "green"),
          theme = ggplot2::theme_dark())

## more interventions
he2 <- BCEA::bcea(cbind(e, e - 0.0002), cbind(c, c + 5))
mypalette <- RColorBrewer::brewer.pal(3, "Accent")
ceac.plot(he2, graph = "ggplot2",
          title = "my title",
          theme = ggplot2::theme_dark(),
          pos = TRUE,
          line = list(colors = mypalette))
ceac.plot(he, graph = "base", title = "my title", line = list(colors = "green"))
ceac.plot(he2, graph = "base")

ceac.plot(he2, graph = "plotly", pos = "bottom")

}
\references{
Baio, G., Dawid, A. P. (2011). Probabilistic Sensitivity
  Analysis in Health Economics. Statistical Methods in Medical Research
  doi:10.1177/0962280211419832.

Baio G. (2012). Bayesian Methods in Health Economics. CRC/Chapman Hall, London.
}
\seealso{
\code{\link{bcea}},
         \code{\link{plot.bcea}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\keyword{hplot}
