% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DW_nodelml.R
\name{DW_nodelml}
\alias{DW_nodelml}
\title{Compute node-marginal likelihoods of a DAG model (internal function)}
\usage{
DW_nodelml(node, DAG, tXX, n, a, U)
}
\arguments{
\item{node}{numerical label of \eqn{node} in \code{DAG}}

\item{DAG}{\eqn{(q,q)} adjacency matrix of \code{DAG}}

\item{tXX}{\eqn{(q,q)} matrix \eqn{X'X} with \eqn{X} the \eqn{(n,q)} data matrix}

\item{n}{number of observations (rows) in the data matrix \eqn{X}}

\item{a}{shape hyperparameter of the DAG Wishart prior}

\item{U}{position hyperparameter of the DAG Wishart prior}
}
\value{
The logarithm of the marginal likelihood of \code{node}
}
\description{
This function computes the log-marginal likelihood of the conditional distribution of variable \code{node}
given its parents in \code{DAG} under a DAG-Wishart prior on the DAG model-parameters
}
