% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{srol2021}
\alias{srol2021}
\title{Data on the social consequences of COVID-19 conspiracy beliefs}
\format{
A data frame with 501 rows and 24 variables
\itemize{
\item \code{id}: participant id
\item \code{gender}: participants' indicated gender (1 = "male", 2 = "female")
\item \code{age}: participants' indicated age
\item \code{education}: participants' indicated highest attained education level(1 = "elementary education", 2 = "high school without diploma", 3 = "high school with diploma", 4 = "undergraduate college degree", 5 = "graduate college degree", 6 = "doctoral degree")
\item \code{combined_covid_conspiracy}: average rating on 12 items of both generic and China-specific COVID-19 conspiracy beliefs
\item \code{china_covid_conspiracy}:  average rating on 4 items of China-specific COVID-19 conspiracy beliefs
\item \code{generic_covid_conspiracy}: average rating on 8 items of generic COVID-19 conspiracy beliefs
\item \code{generic_covid_conspiracy_wo_hoax}: average rating on 7 items of generic COVID-19 conspiracy beliefs (without the hoax theory item)
\item \code{combined_covid_conspiracy_wo_hoax}:  average rating on 11 items of both generic and China-specific COVID-19 conspiracy beliefs (without the hoax theory item)
\item \code{neg_feelings_italy}:score on a feeling thermometer (higher score = more negative feelings) toward Italian people/ 0-100
\item \code{neg_feelings_china}:score on a feeling thermometer (higher score = more negative feelings) toward Chinese people/ 0-100
\item \code{neg_feelings_roma}: score on a feeling thermometer (higher score = more negative feelings) toward Roma people/ 0-100
\item \code{social_distance_italy}: average rating on three items of social distance toward Italian people
\item \code{social_distance_china}: average rating on three items of social distance toward Chinese people
\item \code{social_distance_roma}: average rating on three items of social distance toward Roma people
\item \code{discrimination_italy}: rating on one discrimination item for Italian people
\item \code{discrimination_china}: rating on one discrimination item for Chinese people
\item \code{discrimination_roma}: rating on one discrimination item for Roma people
\item \code{italy_composite}: composite average of 5 z-scores (feeling thermometer, 3 social distance items, and discrimination) for Italian people
\item \code{china_composite}: composite average of 5 z-scores (feeling thermometer, 3 social distance items, and discrimination) for Chinese people
\item \code{roma_composite}: composite average of 5 z-scores (feeling thermometer, 3 social distance items, and discrimination) for Roma people
\item \code{information_exposure}: average rating on the 3 items of exposure to information about COVID-19 pandemic
\item \code{anxiety}: average rating on the 4 items related to feelings of anxiety]
\item \code{lack_of_control}: average rating on the 4 items related to the feeling of lack of control
}
}
\usage{
data("srol2021")
}
\description{
Data from Study 1 in \insertCite{srol2021social}{BBcor} examining effects
of prejudice and descrimination on COVID-19 conspiracy beliefs
}
\details{
Further details can be found at \href{https://osf.io/jkab7/}{https://osf.io/jkab7/}
}
\references{
\insertAllCited{}
}
\keyword{datasets}
