% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_samples.R
\name{posterior_samples}
\alias{posterior_samples}
\title{Extract Posterior Samples}
\usage{
posterior_samples(object, summary = TRUE, cred = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{bbcor}}

\item{summary}{Logical. Should the posterior samples be summarized (defaults to \code{TRUE})?}

\item{cred}{Numeric. If \code{summary = TRUE}, the desired credible interval.}

\item{...}{Currently ignored}
}
\value{
Either a data frame summarizing the relations (\code{summary = TRUE}) or 
a data frame including the posterior samples (\code{summary = FALSE})
}
\description{
Extract Posterior Samples
}
\examples{

Y <- mtcars[,1:5]

bb_samps <- bbcor(Y, method = "spearman")

# correlations
posterior_samples(bb_samps)


# partial correlations
posterior_samples(cor_2_pcor(bb_samps))
}
