% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{aic}
\alias{aic}
\title{Akaike Information Criterion.}
\usage{
aic(obs, est = NULL, param = 0, correct = FALSE)
}
\arguments{
\item{obs}{Either a model or a vector with observed values.}

\item{est}{A vector with estimated values. Only used if obs is not a model.}

\item{param}{Number of parameters in the model. If obs is a model param will be ignored and the number of parameters will be calculated from the model.}

\item{correct}{Boolean indicating whether the corrected version of AIC (AICc) should be calculated, mostly for models with few observations.}
}
\value{
The AIC or AICc value.
}
\description{
Calculates the Akaike Information Criterion (AIC) of any model based on observed and estimated values.
}
\details{
Useful for models or functions that do not provide logLik values.
}
\examples{
obs = c(1,4,5,6)
est = c(0,1,4,7)

#example using values
aic(obs, est)
aic(obs, est, param = 1)
aic(obs, est, param = 1, correct = TRUE)

#example using model
mod = lm(obs ~ est)
aic(mod)
extractAIC(mod)[2]
aic(mod, correct = TRUE)

}
