% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.similarity}
\alias{kernel.similarity}
\title{Pairwise similarity among kernel density hypervolumes.}
\usage{
kernel.similarity(
  comm,
  trait,
  method = "box",
  abund = FALSE,
  return.hv = FALSE,
  ...
)
}
\arguments{
\item{comm}{A HypervolumeList (one hypervolume for each species or community) constructed with the hypervolume R package. Alternatively, a sites x species matrix, with incidence or abundance data about the species in the community.}

\item{trait}{A matrix of traits for each species in comm (a species for each row and traits as columns). Must be provided only if 'comm' is a sites x species matrix.}

\item{method}{Method for constructing the hypervolume. One of "box" (box kernel density estimation), "gaussian" (Gaussian kernel density estimation), or "svm" (one-class support vector machine). See respective functions of the hypervolume package for details. Must be provided only if 'comm' is a sites x species matrix.}

\item{abund}{A boolean (T/F) indicating whether abundance data should be used or converted to incidence before analysis. If not specified, default is FALSE. Ignored if an Hypervolume or HypervolumeList is provided as input data.}

\item{return.hv}{Bolean indicating whether the hypervolume objects used to calculate pairwise similarity should be returned (default is FALSE).}

\item{...}{further arguments to be passed from other methods in hypervolume package.}
}
\value{
Five pairwise distance matrices, one per each of the distance and similarity indexes.
}
\description{
Calculate pairwise distance metrics (centroid and minimum distance) and similarity indices (Intersection, Jaccard, Sørensen-Dice) between n-dimensional hypervolumes.
}
\details{
Computes a pairwise comparison between kernel density hypervolumes of multiple species or communities. See Mammola (2019) for a description of the different indices,
and a comparison between their performance. Note that computation time largely depends on the number of hypervolume objects in the list, and scales almost exponentially with the number of hypervolume axes.
}
\examples{
comm <- rbind(c(0,3,2,1), c(1,5,6,2), c(0,0,2,1))
trait <- cbind(c(2.2,4.4,6.1,8.3),c(0.5,1,0.5,0.4),c(0.7,1.2,0.5,0.4))

#example with community and trait matrices as input data:
#kernel.similarity(comm = comm, trait = trait)

#'#example with a list of hypervolume as input data:
#A = hypervolume_box(trait[,1:2], name = "Community_1")
#B = hypervolume_box(trait[,2:3], name = "Community_2")
#kernel.similarity(hypervolume_join(A,B))
}
\references{
Mammola, S. (2019) Assessing similarity of n-dimensional hypervolumes: Which metric to use?. Journal of Biogeography, 46: 2012-2023.
}
