% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_priors.R
\name{hyper.g}
\alias{hyper.g}
\title{Hyper-g-Prior Distribution for Coefficients in BMA Models}
\usage{
hyper.g(alpha = 3)
}
\arguments{
\item{alpha}{a scalar > 0. The hyper.g(alpha) is equivalent to CCH(alpha -2,
2, 0). Liang et al recommended values in the range 2 < alpha_h <= 3}
}
\value{
returns an object of class "prior", with the family and
hyerparameters.
}
\description{
Creates an object representing the hyper-g mixture of g-priors on
coefficients for BAS.
}
\details{
Creates a structure used for \code{\link{bas.glm}}.
}
\examples{
hyper.g(alpha = 3)
}
\seealso{
\code{\link{CCH}} \code{\link{bas.glm}}

Other beta priors: 
\code{\link{CCH}()},
\code{\link{EB.local}()},
\code{\link{IC.prior}()},
\code{\link{Jeffreys}()},
\code{\link{TG}()},
\code{\link{beta.prime}()},
\code{\link{g.prior}()},
\code{\link{hyper.g.n}()},
\code{\link{intrinsic}()},
\code{\link{robust}()},
\code{\link{tCCH}()},
\code{\link{testBF.prior}()}
}
\author{
Merlise Clyde
}
\concept{beta priors}
