% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_priors.R
\name{hyper.g.n}
\alias{hyper.g.n}
\title{Generalized hyper-g/n Prior Distribution for g for mixtures of g-priors on
Coefficients in BMA Models}
\usage{
hyper.g.n(alpha = 3, n = NULL)
}
\arguments{
\item{alpha}{a scalar > 0, recommended 2 < alpha <= 3}

\item{n}{The sample size; if NULL, the value derived from the data in the
call to `bas.glm` will be used.}
}
\value{
returns an object of class "prior", with the family and
hyerparameters.
}
\description{
Creates an object representing the hyper-g/n mixture of g-priors on
coefficients for BAS. This is a special case of the tCCH prior
}
\details{
Creates a structure used for \code{\link{bas.glm}}.  This is a special case
of the \code{\link{tCCH}}, where \code{hyper.g.n(alpha=3, n)} is equivalent
to \code{ tCCH(alpha=1, beta=2, s=0, r=1.5, v = 1, theta=1/n) }
}
\examples{
n <- 500
hyper.g.n(alpha = 3, n = n)
}
\seealso{
\code{\link{tCCH}}, \code{\link{robust}}, \code{\link{hyper.g}},
\code{\link{CCH}}\code{\link{bas.glm}}

Other beta priors: \code{\link{CCH}},
  \code{\link{EB.local}}, \code{\link{IC.prior}},
  \code{\link{Jeffreys}}, \code{\link{TG}},
  \code{\link{beta.prime}}, \code{\link{g.prior}},
  \code{\link{hyper.g}}, \code{\link{intrinsic}},
  \code{\link{robust}}, \code{\link{tCCH}},
  \code{\link{testBF.prior}}
}
\author{
Merlise Clyde
}
\concept{beta priors}
