% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getmrca.R
\name{getmrca}
\alias{getmrca}
\title{Find most recent common ancestors}
\usage{
getmrca(phy, t1, t2)
}
\arguments{
\item{phy}{An object of class \code{phylo}.}

\item{t1}{A vector of mode integer or character corresponding to tips in
\code{phy}.}

\item{t2}{A vector of mode integer or character corresponding to tips in
\code{phy}.}
}
\value{
A vector of node numbers of the common ancestor for each pair of
    tips.
}
\description{
Calculates the most recent common ancestor for each pair of
    tips. Used internally by \code{\link{getEventData}}.
}
\details{
Finds the most recent common ancestor for each pair of tips where
    pairs are defined as (\code{t1}[1], \code{t2}[1]), (\code{t1}[2],
    \code{t2}[2]), ... , (\code{t1}[i], \code{t2}[i]), ... ,(\code{t1}[n],
    \code{t2}[n]).
}
\seealso{
\code{\link{subtreeBAMM}}
}
\author{
Mike Grundler
}
\keyword{manip}
