% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_model_select.R
\name{fit_incremental_angmix}
\alias{fit_incremental_angmix}
\title{Stepwise fitting of angular mixture models with incremental component sizes and optimum model selection}
\usage{
fit_incremental_angmix(
  model,
  data,
  crit = "LOOIC",
  start_ncomp = 1,
  max_ncomp = 10,
  L = NULL,
  fn = mean,
  fix_label = NULL,
  form = 2,
  start_par = NULL,
  prev_par = TRUE,
  logml_maxiter = 10000,
  return_all = FALSE,
  save_fits = FALSE,
  save_file = NULL,
  save_dir = "",
  silent = FALSE,
  return_llik_contri = (crit \%in\% c("LOOIC", "WAIC")),
  use_best_chain = TRUE,
  alpha = 0.05,
  bonferroni_alpha = TRUE,
  bonferroni_adj_type = "decreasing",
  ...
)
}
\arguments{
\item{model}{angular model whose mixtures are to be fitted. Available choices are \code{"vmsin", "vmcos"} and \code{"wnorm2"} for
bivariate data, and \code{"vm"} and \code{"wnorm"} for univariate data.}

\item{data}{data matrix (if bivarate, in which case it must have two columns) or vector. If outside, the values
are transformed into the scale \eqn{[0, 2\pi)}. *Note:* BAMBI cannot handle missing data. Missing values must
either be removed or properly imputed.}

\item{crit}{model selection criteria, one of \code{"LOOIC", "WAIC", "AIC", "BIC", "DIC"} or \code{"LOGML"}. Default is
\code{"LOOIC"}.}

\item{start_ncomp}{starting component size. A single component model is fitted if \code{start_ncomp} is equal to one.}

\item{max_ncomp}{maximum number of components allowed in the mixture model.}

\item{L}{HMC tuning parameter (trajectory length) passed to \link{fit_angmix}. Can be a numeric vetor (or scalar), in which case
the same \code{L} is passed to all \link{fit_angmix} calls, or can be a list of length \code{max_ncomp-start_ncomp+1},
so that \code{L_list[[i]]} is passed as the argument \code{L} to \link{fit_angmix} call with \code{ncomp = max_ncomp+i-1}. See
\link{fit_angmix} for more details on \code{L} including its default values. Ignored if \code{method = "rwmh"}.}

\item{fn}{function to evaluate on MCMC samples to estimate parameters.
Defaults to \code{mean}, which computes the estimated posterior means. If \code{fn = max},
then MAP estimate is calculated from the MCMC run. Used only if \code{crit = "DIC"}, and ignored otherwise.}

\item{fix_label}{logical. Should the label switchings on the current fit (only the corresponding "best chain" if \code{use_best_chain = TRUE})
be fixed before computing parameter estimates and model selection criterion? Defaults to \code{TRUE} if \code{perm_sampling} is true in
the \link{fit_angmix} call, or if \code{crit = "DIC"} and \code{form = 1}.}

\item{form}{form of crit to be used. Available choices are 1 and 2. Used only if \code{crit} is \code{"DIC"} and ignored otherwise.}

\item{start_par}{list with elements \code{pmix} (ignored if \code{comp == 1}), together with \code{kappa1, kappa2, mu1} and \code{mu2},
for bivariate models, and \code{kappa} and \code{mu} for univariate models,
all being vectors of length same as \code{ncomp}.
These provides the starting values for the Markov chain; with \eqn{j}-th component of each vector corresponding to the \eqn{j}-th
component of the mixture distribution. If missing, the data is first clustered into \code{ncomp} groups either via k-means (after
projecting onto a unit sphere), or randomly, depending on \code{rand_start},  and then moment estimators for components are used as
the starting points. Note that a very wrong starting point can potentially lead the chain to get stuck at a wrong solution for thousands
of iterations. As such, we recommend using the default option, which is k-means followed by moment estimation.}

\item{prev_par}{logical. Should the MAP estimated parameters from the model with \code{ncomp = K} be used in the model
with \code{ncomp = K+1} as the starting parameters, with the component with largest mixing proportion appearing twice in the
bigger model?}

\item{logml_maxiter}{maximum number of iterations (\code{maxiter}) passed to \link{bridge_sampler} for calculating
\code{LOGML}. Ignored if \code{crit} is not \code{LOGML}.}

\item{return_all}{logical. Should all angmcmc objects obtained during step-wise run be returned? *Warning*: depending on the
sizes of \code{n.iter}, \code{start_ncomp}, \code{max_ncomp} and \code{n.chains}, this can be very memory intesive. In such
cases, it is recommended that \code{return_all} be set to \code{FALSE}, and, if required, the intermediate fitted objects be
saved to file by setting \code{save_fits = TRUE}.}

\item{save_fits}{logical. Should the intermediate angmcmc objects obtained during step-wise run be saved
to file using \link{save}? Defaults to TRUE. See \code{save_file} and \code{save_dir}.}

\item{save_file, save_dir}{\code{save_file} is a list of size \code{max_ncomp-start_ncomp+1},
with k-th entry providing the \code{file}
argument used to \link{save} the intermediate angmcmc object with \code{ncomp = k} (titled \code{"fit_angmcmc"}).
If not provided, then k-th element
of \code{save_file[[k]]} is taken to be \code{\link{paste}(save_dir, "comp_k", sep="/")}. Both are ignored if
\code{save_fits = FALSE}.}

\item{silent}{logical. Should the current status (such as what is the current component labels, which job is being done etc.)
be printed? Defaults to \code{TRUE}.}

\item{return_llik_contri}{passed to \link{fit_angmix}. By default, set to \code{TRUE} if \code{crit} is either \code{"LOOIC"}
or \code{"WAIC"}, and to \code{FALSE} otherwise.}

\item{use_best_chain}{logical. Should only the "best" chain obtained during each intermediate fit be used during
computation of model selection criterion? Here "best" means the chain
with largest (mean over iterations) log-posterior density. This can be helpful if one of the chains gets stuck at local optima. Defaults to TRUE.}

\item{alpha}{significance level used in the test H_{0K}: expected log predictive density (elpd) for the fitted model with  K components >= elpd for the fitted model
with K + 1 components if \code{crit} is \code{"LOOIC"} or \code{"WAIC"}.
Must be a scalar between 0 and 1. Defaults to 0.05. See Details. Ignored for any other \code{crit}.}

\item{bonferroni_alpha}{logical. Should a Bonferroni correction be made on the test size \code{alpha} to adjust for
multiplicity due to (\code{max_ncomp} - \code{start_ncomp}) possible hypothesis tests? Defaults to TRUE.
Relevant only if \code{crit} is in  \code{c("LOOIC", "WAIC")}, and ignored otherwise. See Details.}

\item{bonferroni_adj_type}{character string. Denoting type of Bonferroni adjustment to make.
Possible choices are \code{"decreasing"} (default) and \code{"equal"}. Ignored if either \code{bonferroni_alpha}
is FALSE, or \code{crit} is outside \code{c("LOOIC", "WAIC")}. See Details.}

\item{...}{additional arguments passed to \link{fit_angmix}.}
}
\value{
Returns a named list (with class = \code{stepfit}) with the following seven elements:

\code{fit.all} (if \code{return_all = TRUE}) - a list all angmcmc objects created at each component size;

\code{fit.best} - angmcmc object corresponding to the optimum component size;

\code{ncomp.best} - optimum component size (integer);

\code{crit} - which model comparison criterion used (one of \code{"LOOIC", "WAIC", "AIC", "BIC", "DIC"} or \code{"LOGML"});

\code{crit.all} - all \code{crit} values calculated (for all component sizes);

\code{crit.best} - \code{crit} value for the optimum component size; and

\code{maxllik.all} - maximum (obtained from MCMC iterations) log likelihood for all fitted models

\code{maxllik.best} - maximum log likelihodd for the optimal model; and

\code{check_min} - logical; is the optimum component size less than \code{max_ncomp}?
}
\description{
Stepwise fitting of angular mixture models with incremental component sizes and optimum model selection
}
\details{
The goal is to fit an angular mixture model with an optimally chosen component size K.
To obtain an optimum K, mixture models with incremental component sizes
between \code{start_ncomp} and \code{max_ncomp} are fitted incrementally using \link{fit_angmix},
starting from K = 1.
If the model selection criterion \code{crit} is \code{"LOOIC"} or \code{"WAIC"}, then a test of hypothesis
H_{0K}: expected log predictive density (elpd) for the fitted model with  K components >= elpd for the fitted model
with K + 1 components, is performed at every K >= 1. The test-statistic used for the test is an approximate z-score
based on the normalized estimated elpd difference between the two models obtained from \link[loo]{compare}, which provides
estimated elpd difference along with its standard error estimate. Because the computed standard error of elpd difference
can be overly optimistic when the elpd difference is small (in particular < 4),
a conservative worst-case estimate (equal to twice of the computed standard error)
is used in such cases. To account for multiplicity among the M =
(\code{max_ncomp} - \code{start_ncomp}) possible sequential tests performed,
by default a Bonferroni adjustment to the test level \code{alpha} is made.
Set \code{bonferroni_alpha = FALSE} to remove the adjustment. To encourage
parsimony in the final model, by default (\code{bonferroni_adj_type = "decreasing"})
a decreasing sequence of adjusted alphas of the form \code{alpha * (0.5)^(1:M) / sum((0.5)^(1:M))}
is used. Set \code{bonferroni_adj_type = "equal"}
to use equal sequence of adjusted alphas (i.e., \code{alpha/M}) instead.

The incremental fitting stops if  H_{0K} cannot be rejected
(at level \code{alpha}) for some K >= 1; this K is then regarded as the optimum number of components.
If \code{crit} is not \code{"LOOIC"} or \code{"WAIC"} then mixture model with the first minimum value of the model selection criterion \code{crit}
is taken as the best model.

Note that in each intermediate fitted model, the total number of components (instead of the number of
"non-empty components") in the model is used to estimate of the true component
size, and then the fitted model is penalized for model complexity (via the model selection criterion used).
This approach of selecting an optimal K follows the perspective "let two component specific parameters
be identical" for overfitting mixtures, and as such the  Dirichlet prior hyper-parameters \code{pmix.alpha}
(passed to \link{fit_angmix}) should be large. See  Fruhwirth-Schnatter (2011) for more deltails.

Note that the stability of \link{bridge_sampler} used in marginal likelihood estimation heavily depends on stationarity of the
chains. As such, while using this criterion, we recommending running the chain long engouh, and setting \code{fix_label = TRUE}
for optimal performance.
}
\examples{
# illustration only - more iterations needed for convergence
set.seed(1)
fit.vmsin.step.15 <- fit_incremental_angmix("vmsin", tim8, "BIC", start_ncomp = 1,
                                          max_ncomp = 3, n.iter = 15,
                                          n.chains = 1, save_fits=FALSE)
(fit.vmsin.best.15 <- bestmodel(fit.vmsin.step.15))
lattice::densityplot(fit.vmsin.best.15)

}
\references{
Fruhwirth-Schnatter, S.: Label switching under model uncertainty. In: Mengerson, K., Robert, C., Titterington, D. (eds.) Mixtures:
Estimation and Application, pp. 213-239. Wiley, New York (2011).
}
