% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{waic.angmcmc}
\alias{waic.angmcmc}
\title{Watanabe-Akaike Information Criterion (WAIC) for angmcmc objects}
\usage{
\method{waic}{angmcmc}(x, ...)
}
\arguments{
\item{x}{angmcmc object.}

\item{...}{additional model specific arguments to be passed to \link{waic} from loo. For example, \code{int.displ}
specifies integer displacement in wnorm and wnorm2 models. See \link{fit_wnormmix} and
\link{fit_wnorm2mix} for more details.}
}
\value{
Computes the WAIC for a given angmcmc object.
}
\description{
Watanabe-Akaike Information Criterion (WAIC) for angmcmc objects
}
\details{
Given a deviance function \eqn{D(\eta) = -2 \log(p(y|\eta))}, and an estimate
\eqn{\eta* = (\sum \eta_i) / n} of the posterior mean
\eqn{E(\eta|y)}, where \eqn{y = (y_1, ..., y_n)} denote the data, \eqn{\eta} is the unknown
parameter vector of the model, \eqn{\eta_1, ..., \eta_N} are MCMC samples from the posterior
distribution of \eqn{\eta} given \eqn{y} and \eqn{p(y|\eta)} is the likelihood function,
the Watanabe-Akaike Information Criterion (WAIC) is defined as
\deqn{WAIC = LPPD - p_W}
where
\deqn{LPPD  = \sum_{i=1}^n \log (N^{-1} \sum_{s=1}^N p(y_i|\eta_s) )}
and (form 1 of)
\deqn{p_W =  2 \sum_{i=1}^n [ \log (N^{-1} \sum_{s=1}^N p(y_i|\eta_s) ) - N^{-1} \sum_{s=1}^N \log \:p(y_i|\eta_s) ].}
An alternative form (form 2) for \eqn{p_W} is given by
\deqn{p_W = \sum_{i=1}^n \hat{var} \log p(y_i|\eta)}
where for \eqn{i = 1, ..., n}, \eqn{\hat{var} \log p(y_i|\eta)} denotes the estimated variance
of \eqn{\log p(y_i|\eta)} based on the realizations \eqn{\eta_1, ..., \eta_N}.

Note that waic.angmcmc calls \link{waic} for computation. If the likelihood contribution of each data
point for each MCMC iteration is available in \code{object} (can be returned by setting \code{return_llik_contri = TRUE})
during \link{fit_angmix} call), \code{waic.array} is used; otherwise \code{waic.function} is
called. Computation is much faster if the likelihood contributions are available - however, they are very
memory intensive, and by default not returned in \link{fit_angmix}.
}
\examples{
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1, return_llik_contri = TRUE)
library(loo)
waic(fit.vmsin.20)

}
