% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_diagnostics.R
\name{densityplot2d}
\alias{densityplot2d}
\title{Density surface for angmcmc objects with bivariate data}
\usage{
densityplot2d(object, fn = mean, burnin = 1/3, thin = 1,
  log.density = FALSE, theta = 30, phi = 30, shade = 0.01,
  expand = 0.5, ...)
}
\arguments{
\item{object}{angular MCMC object (with bivariate data).}

\item{fn}{function to evaluate on MCMC samples to estimate parameters.  Defaults to \code{mean}, which computes the estimated posterior mean.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}

\item{log.density}{logical. Should log density be used for the plot?}

\item{theta, phi, shade, expand}{arguments passed to \code{\link{persp}} from \code{\link{graphics}}.}

\item{...}{additional arguments passed to \code{\link{persp}} from \code{\link{graphics}}.}
}
\description{
Density surface for angmcmc objects with bivariate data
}
\details{
\code{densityplot2d} is a wrapper for \code{\link{persp}} from graphics applied on angmcmc objects.

To estimate the mixture density, first the parameter vector \eqn{\eta} is estimated
by applying \code{fn} on the MCMC samples, yielding the (consistent) Bayes estimate \eqn{\hat{\eta}}. Then the mixture density
\eqn{f(x|\eta)} at any point \eqn{x} is (consistently) estimated by \eqn{f(x|\hat{\eta})}.
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
# now create density surface with the default first 1/3 as burn-in and thin = 1
densityplot2d(fit.vmsin.20)
# the viewing angles can be changed through the arguments theta and phi
# (passed to persp from graphics)
densityplot2d(fit.vmsin.20, theta = 45, phi = 45)

}
