% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_aci_methods.R
\name{get_aci}
\alias{get_aci}
\alias{list_acis}
\title{Get Azure Container Instance (ACI)}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{
\preformatted{get_aci(name)
list_acis()
}
}

\section{Arguments}{

\itemize{
\item \code{name}: For \code{get_aci()}, the name of the container instance resource.
}
}

\section{Details}{

The \code{AzureRMR::az_resource_group} class has both \code{get_aci()} and \code{list_acis()} methods, while the \code{AzureRMR::az_subscription} class only has the latter.
}

\section{Value}{

For \code{get_aci()}, an object of class \code{az_container_instance} representing the instance resource.

For \code{list_acis()}, a list of such objects.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

rg$get_aci("mycontainer")

}
}
\seealso{
\link{create_aci}, \link{delete_aci}

\link{az_container_instance}

\href{https://docs.microsoft.com/en-us/azure/container-instances/}{ACI documentation} and
\href{https://docs.microsoft.com/en-us/rest/api/container-instances/}{API reference}

\href{https://docs.docker.com/engine/reference/commandline/cli/}{Docker commandline reference}
}
