% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore_Survival.R
\name{AutoScore_rank_Survival}
\alias{AutoScore_rank_Survival}
\title{AutoScore STEP (1) for survival outcomes: Generate variable ranking
  List by machine learning (Random Survival Forest) (AutoScore Module 1)}
\usage{
AutoScore_rank_Survival(train_set, ntree = 50)
}
\arguments{
\item{train_set}{A processed \code{data.frame} that contains data to be analyzed, for training.}

\item{ntree}{Number of trees in the random forest (Default: 100).}
}
\value{
Returns a vector containing the list of variables and its ranking generated by machine learning (random forest)
}
\description{
AutoScore STEP (1) for survival outcomes: Generate variable ranking
  List by machine learning (Random Survival Forest) (AutoScore Module 1)
}
\details{
The first step in the AutoScore framework is variable ranking. We
  use Random Survival Forest (RSF) for survival outcome to identify the
  top-ranking predictors for subsequent score generation. This step
  correspond to Module 1 in the AutoScore-Survival paper.
}
\examples{
\dontrun{
# see AutoScore-Survival Guidebook for the whole 5-step workflow
data("sample_data_survival") # Output is named `label_time` and `label_status`
ranking <- AutoScore_rank_Survival(sample_data_survival, ntree = 50)
}
}
\references{
\itemize{
 \item{Ishwaran, H., Kogalur, U. B., Blackstone, E. H., & Lauer, M. S. (2008).
 Random survival forests. The annals of applied statistics, 2(3), 841-860.}
 \item{Xie F, Ning Y, Yuan H, et al. AutoScore-Survival: Developing
 interpretable machine learning-based time-to-event scores with right-censored
 survival data. J Biomed Inform. 2022;125:103959. doi:10.1016/j.jbi.2021.103959}
}
}
\seealso{
\code{\link{AutoScore_parsimony_Survival}},
  \code{\link{AutoScore_weighting_Survival}},
  \code{\link{AutoScore_fine_tuning_Survival}},
  \code{\link{AutoScore_testing_Survival}}.
}
