% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DR_main.R
\name{dr}
\alias{dr}
\title{Distance regression}
\usage{
dr(simi.mat, null.space, x.mat, permute = TRUE, n.MonteCarlo = 1000,
  seed = NULL)
}
\arguments{
\item{simi.mat}{a similarity matrix among the subjects.}

\item{null.space}{a numeric vector to show the column numbers of
the null space in \code{x.mat}.}

\item{x.mat}{the covariate matrix which combines the null space
and the matrix of interest.}

\item{permute}{logical. If \code{TRUE}, the Monte Carlo sampling is used
without replacement; otherwise, with replacement. The default is
\code{TRUE}.}

\item{n.MonteCarlo}{the number of times for the Monte Carlo
procedure. The default is \code{1000}.}

\item{seed}{if it is not \code{NULL}, set the random number generator
state for random number generation. The default is \code{NULL}.}
}
\value{
A list with class "\code{htest}" containing the following components:
\tabular{llll}{
\code{statistic} \tab \tab \tab \cr
\tab \tab \tab the observed value of the test statistic.\cr
\code{p.value} \tab \tab \tab \cr
\tab \tab \tab the p-value for the test.\cr
\code{alternative} \tab \tab \tab \cr
\tab \tab \tab a character string describing the alternative hypothesis.\cr
\code{method} \tab \tab \tab \cr
\tab \tab \tab a character string indicating the type of test performed.\cr
\code{data.name} \tab \tab \tab \cr
\tab \tab \tab a character string giving the names of the data.
}
}
\description{
Conduct the distance regression with or without the adjustment of
the covariates to detect the association between a distance matrix
and some independent variants of interest.
}
\details{
The pseudo \emph{F} statistic based on the distance regression with
or without the adjustment of the covariates detects the
association between a distance matrix and some independent
variants of interest. A distance matrix can be transformed into a
similarity matrix easily.
}
\examples{
data(drS.eg)
null.space <- 1
x.mat <- matrix(c(rep(1, 600), rep(0, 200)), ncol=2)
dr(drS.eg, null.space, x.mat, permute = TRUE, n.MonteCarlo = 50, seed = NULL)
}
\references{
Q Li, S Wacholder, DJ Hunter, RN Hoover, S Chanock, G
Thomas, and K Yu. Genetic Background Comparison Using
Distance-Based Regression, with Applications in Population
Stratification Evaluation and Adjustment. \emph{Genetic
Epidemiology}. 2009; 33(5): 432-441.

J Wessel and NJ Schork. Generalized Genomic
Distance-Based Regression Methodology for Multilocus Association
Analysis. \emph{American Journal of Human Genetics}. 2006; 79(5):
792-806.

MA Zapala and NJ Schork. Multivariate Regression
Analysis of Distance Matrices for Testing Associations Between
Gene Expression Patterns and Related Variables. \emph{Proceedings
of the National Academy of Sciences of the United States of
America}. 2006; 103(51): 19430-19435.
}
\author{
Lin Wang, Wei Zhang, and Qizhai Li.
}
