% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tactical_AAA.R
\name{tactical_AAA}
\alias{tactical_AAA}
\title{Returns allocations for the Adaptive Asset Allocation strategy on a given
date}
\usage{
tactical_AAA(strat, reb_date, P, R, risk_free)
}
\arguments{
\item{strat}{A list representing an asset allocation strategy. For this
particular strategy, \code{strat$asset_class} must contain a character vector
containing the corresponding asset classes.}

\item{reb_date}{A date on which the allocation rule is applied.}

\item{P}{An xts object with daily prices of the tickers in strat.}

\item{R}{An xts object with daily returns of the tickers in strat.}

\item{risk_free}{Either an xts object with daily returns of the risk-free
asset, or a scalar numeric with the annual risk-free rate in decimals.}
}
\value{
A numeric vector of weights after applying the rule.
}
\description{
\code{tactical_AAA} determines asset allocations according to the Adaptive
Asset Allocation approach described in Butler, Philbrick, Gordillo, and
Varadi (2012) <doi:https://dx.doi.org/10.2139/ssrn.2328254>.
}
\details{
The Adaptive Asset Allocation strategy sorts a specific list of assets
based on 6-month momentum, selects the top 5 assets, and then calculates
weights that yield the minimum portfolio variance. The parameters controlling
the number of months for the momentum calculation (\code{n_months_mom},
default = 6), number of months of daily data used to estimate the covariance
matrix (\code{n_months_mom}, default value = 1), and the number of assets to
select using the momentum rule (\code{n_assets}, default = 5) can be changed
by adding them to a list called \code{param} in the \code{strat} object. This
allows the user to apply the simple principle of the strategy (momentum and
minimum variance) to any set of assets.
}
