\name{get_rebalance_dates}
\alias{get_rebalance_dates}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{get_rebalance_dates
%%  ~~function to do ... ~~
}
\description{
This is a helper function used by backtest_allocation to determine the rebalancing dates based on user choices. This function is not intended to be directly executed by users of the package.
}
\usage{
get_rebalance_dates(dates, reb_freq, k = 1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{dates}{vector of dates corresponding to the returns matrix}
  \item{reb_freq}{rebalance frequency with one of the following values: "days", "weeks", "months", "quarters", or "years"}
  \item{k}{number of periods to skip. For example, if reb_freq is "months" and k = 2, the rebalancing will be done every 2 months.}
}
\value{
A vector of rebalance dates.
}

\author{
Alexandre Rubesam
}

\examples{
# get dates for the provided ETF data set
dates <- zoo::index(ETFs_daily)
(reb_dates_monthly <- get_rebalance_dates(dates, "months"))

# rebalancing every 3 months
(reb_dates_monthly <- get_rebalance_dates(dates, "months", k=3))

# rebalancing weekly
(reb_dates_monthly <- get_rebalance_dates(dates, "weeks"))
}

