% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AssayCorrector.R
\name{create_assay}
\alias{create_assay}
\title{Create a new \code{assay}}
\usage{
create_assay(m, ctrl = NA)
}
\arguments{
\item{m}{The assay you want to be corrected}

\item{ctrl}{An optional boolean array of the same dimensions as \code{m}. Each entry is 1 if the well is a control well, 0 otherwise. All control wells are excluded from all computations}
}
\value{
assay The created assay object.
It containts the following fields:

\code{n} The HTS matrix of raw measurements

\code{ctrl} The binary matrix of control wells

\code{biasPositions} The binary matrix where 1:well is biased, 0:well is unbiased, as suggested by Mann-Whitney test

\code{mCorrected} The HTS matrix of corrected measurements, initilized to a zero array, and subsequently storing the corrected version of \code{m} via \code{correct_bias()}

\code{biasType} Vector of length p, where p is the number of plates. It tells, for each plate of the assay, A:Additive trend, M:Multiplicative trend, U:Undetermined trend and C:Error-free plate.

\code{biasModel} Vector of length p, where p is the number of plates. It tells, for each plate of the assay, the most likely spatial bias model (1 through 6)

\code{biasConf} Vector of length p, where p is the number of plates. It tells, for each plate of the assay, the confidence in the model, (0 - lowest to 3-  highest). It is computed by counting the number of bias models (additive or mutliplicative) which agree together.
}
\description{
\code{create_assay} makes a new object of class assay. You should pass this object to \code{detect_bias()} and \code{correct_bias()} methods
}
\examples{
# Fictive 8x12x5 assay
assay<-create_assay(m)
# Plate 7 taken from Carralot et al. 2012
assay<-create_assay(plate7)
}
