% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiMarginalPlot.R
\name{MultiMarginalPlot}
\alias{MultiMarginalPlot}
\title{Marginal posterior densities of several events}
\usage{
MultiMarginalPlot(
  data,
  position,
  level = 0.95,
  GridLength = 1024,
  x.scale = rep("calendar", length(position)),
  elapsed.origin = NULL,
  title = "Characteristics of several dates",
  subtitle = NULL,
  caption = "ArchaeoPhases",
  x.label = "Calendar year",
  y.label = NULL,
  y.grid = TRUE,
  x.min = NULL,
  x.max = NULL,
  legend.title = "Legend",
  height = 7,
  width = 7,
  units = "in",
  file = NULL,
  newWindow = TRUE
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the position of the column
corresponding to the MCMC chains of interest.}

\item{level}{Probability corresponding to the level of confidence.}

\item{GridLength}{Number of equally spaced points at which the
density is to be estimated (for \code{density()} function).}

\item{x.scale}{One of "calendar" for calendar years,
"BP" for years before present,
or "elapsed" for time elapsed from a specified origin.}

\item{elapsed.origin}{Position of the column to use
as the origin for elapsed time calculations.}

\item{title}{Title of the plot.}

\item{subtitle}{Subtitle of the plot.}

\item{caption}{Caption of the plot.}

\item{x.label}{Label of the x-axis.}

\item{y.label}{Label of the y-axis.}

\item{y.grid}{Switch for horizontal grid lines.}

\item{x.min}{Minimum x-axis value.}

\item{x.max}{Maximum x-axis value.}

\item{legend.title}{Title for the legend.}

\item{height}{Plot height in \code{units}.}

\item{width}{Plot width in \code{units}.}

\item{units}{String recognized by the \code{ggsave()} function,
one of "in", "cm", "mm".}

\item{file}{Name of the file that will be saved if specified,
default = \code{NULL}.}

\item{newWindow}{Whether or not the plot is drawn within a new window.}
}
\value{
\code{NULL}, called for its side effects
}
\description{
Draws a plot of the estimated marginal posterior density for a parameter
and adds the mean and the credible interval at the desired level
}
\details{
The density is estimated using \code{density()} function with
n = \code{GridLength.} The input MCMC chains should either be in
calendar years or converted to calendar years using \code{x.scale} vector or
\code{elapsed.origin}.
}
\examples{
  data(Events);
  MultiMarginalPlot(Events, position = c(2, 3, 4), level = 0.95)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
