% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{PhaseTimeRange}
\alias{PhaseTimeRange}
\title{Phase Time Range}
\usage{
PhaseTimeRange(PhaseMin_chain, PhaseMax_chain, level = 0.95)
}
\arguments{
\item{PhaseMin_chain}{numeric vector containing the output of the MCMC algorithm for the minimum of the dates included in the phase}

\item{PhaseMax_chain}{numeric vector containing the output of the MCMC algorithm for the maximum of the dates included in the phase}

\item{level}{probability corresponding to the desired level of confidence}
}
\value{
A vector of values containing the desired level of confidence and the endpoints of the shortest time range associated with this desired level.
}
\description{
Computes the shortest interval [IntervalInf ; IntervalSup ] that satisfies : P(PhaseMin_chain =< IntervalInf < IntervalSup =< PhaseMax_chain | M) = level.
}
\examples{

  data(Phases); attach(Phases)
  PhaseTimeRange(Phase.1.alpha, Phase.1.beta, 0.95)
  PhaseTimeRange(Phase.2.alpha, Phase.2.beta, 0.90)

}
\keyword{ phase time range}
\keyword{ individual phase}
