% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_functions.R
\name{preselphen}
\alias{preselphen}
\title{Preselecting offspring based on phenotype}
\usage{
preselphen(
  gen,
  batch = 0,
  withinfam = TRUE,
  Nenv,
  Npresel,
  trait,
  Ntraits = BPdata$Ntraits
)
}
\arguments{
\item{gen}{The generation of the offspring.}

\item{batch}{The batch of the offspring. Default is 0.}

\item{withinfam}{Preselection within a full sib family or not, default is TRUE.}

\item{Nenv}{The number of environments the fish need to be preselected for, for example a certain number of fish need to be preselected for a nucleus and a certain number of fish need to be preselected for a production environment in order to measure sib traits. Preselection is based on the same trait.}

\item{Npresel}{A vector of the number of fish that needs to be preselected for each environment.}

\item{trait}{The trait on which the phenotypic preselection is based, for example trait = 2.}

\item{Ntraits}{The total number of simulated traits. Needs to be specified if Ntraits is not specified in a list called 'BPdata'.}
}
\value{
This function will make changes to the data frame called 'ped'. Fish that are pre-selected will get a number assigned to their column 'preselected'.
}
\description{
This function can be used to preselect offspring based on the phenotype of one trait.
}
\examples{

\donttest{ped <- founderpopfam(Nm = 60,
                     Nf = 60,
                     Nm2 = 0,
                     Nf2 = 0,
                     Ntraits = 2,
                     TraitsIndex = 2,
                     Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                     Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                     Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                     mean = c(50,500),
                     a_var = c(200,8000),
                     c_var = c(150,1000),
                     e_var = c(250,12000))
                     
Mating <- randommating(gen = 0,
                       Nfam_FS = 120)

for(fam in 1: nrow(Mating)){
ped <- offspringFSfam(gen = 1,
                      No = 100,
                      probmale = 0.5,
                      sire = Mating$Sire[fam],
                      dam = Mating$Dam[fam],
                      Ntraits = 2,
                      TraitsIndex = 2,
                      Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                      Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                      Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                      a_var = c(200,8000),
                      c_var = c(150,1000),
                      e_var = c(250,12000))
}

ped <- preselphen(gen = 1,
                  Nenv = 2,
                  Npresel = c(25,15),
                  trait = 1,
                  Ntraits = 2)
}                  
                  
                  
\donttest{ped <- founderpopgroup(Nm = 60,
                     Nf = 60,
                     Nm2 = 0,
                     Nf2 = 0,
                     batch = c(-3,-2,-1,0),
                     Ntraits = 2,
                     TraitsIndex = 2,
                     Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                     Rcom = matrix(c(1.00  , 0,
                                    0   , 1.00),
                                 nrow = 2),
                     Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                     mean = c(50,500),
                     a_var = c(200,8000),
                     c_var = c(0,0),
                     e_var = c(250,12000))
 
Mating <- groupmating(gen = 0,
                       batch =-3,
                       No = 1000,
                       contr_m = 0.5,
                       contr_f = 0.5)                    
                     
for(fam in 1: nrow(Mating)){
ped <- offspringFSgroup(gen = 1,
                      No = Mating$No[fam],
                      probmale = 0.5,
                      sire = Mating$Sire[fam],
                      dam = Mating$Dam[fam],
                      batch = 1,
                      Ntraits = 2,
                      TraitsIndex = 2,
                      Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                      Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                      Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                      a_var = c(200,8000),
                      c_var = c(150,1000),
                      e_var = c(250,12000))
}

ped <- preselphen(gen = 1,
                  batch = 1,
                  withinfam = FALSE,
                  Nenv = 2,
                  Npresel = c(400,150),
                  trait = 1,
                  Ntraits = 2)
                  }
}
