% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_CreateMedoids.R
\name{createMedoid}
\alias{createMedoid}
\title{Creates Ancestry Mapper Population Reference.}
\usage{
createMedoid(pathTotpeds, AMmcapply = F, nrcores, wd, pathAll00,
  chipMan = "ChipMan", OutForm = "rda")
}
\arguments{
\item{pathTotpeds}{Character vector giving path to folder containing tPED file(s) to be used.}

\item{AMmcapply}{Logical value (TRUE or FALSE), specifying if the multicore funcion mcapply, should be used. Inappropriate for most HPC cluster systems.
Default = FALSE}

\item{nrcores}{Numeric value detailing how many cores should be used if AMmcapply==TRUE. If left unspecificed the number of cores will be detected and mc.cores will be set to that number -1.}

\item{wd}{Character vector giving the desired working directory to house the outputs of calculateAMids. If left unspecified will use current working directory.}

\item{pathAll00}{Character vector giving the path to a file containing the full data table of each dbSNP and both alleles. A toy version covering the SNPs used in the toy data is included. A full version can be found at: http://bit.ly/1OUstDP}

\item{chipMan}{Character vector giving name of company from which the SNP panel is derived. Eg 'Illumina', 'Affymetrix'. If no value is given will default to 'ChipMan'. If it is whole genome sequencing, please put 'WG'.
The value will appear in the name of the arithmetic reference file. e.g. 'medoidArithmetic_Yoruba_HGDP_1000_Illumina.rda'.}

\item{OutForm}{Character vector giving option for output format for arithmetic medoids. Can be one of three options.
'ods' will generate a raw text file with the default extension of '.ods'. This is the default option as is the most flexible format.
'rds' will save the arithmetic medoid as a .rds file which can be loaded into R faster and is also roughly a third the size of the raw text version.
'rda' will save the arithmetic medoid as a .rda file which can be loaded into R faster and is also roughly a third the size of the raw text version.}
}
\description{
Generates arithmetic population reference from PLINK tPED files.
}
\examples{
\dontrun{
chipManExample <- 'Illumina'
tpeds <- system.file('extdata', package='AncestryMapper')

createMedoid(pathTotpeds = tpeds, chipMan = chipManExample)

}
}

