% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamesHowellTest.R
\name{GHTest}
\alias{GHTest}
\title{Games-Howell Post Hoc Test}
\usage{
GHTest(modelo, alpha = 0.05)
}
\arguments{
\item{modelo}{An object from \code{aov} or \code{lm}.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"gameshowell"} and \code{"comparaciones"},
which contains:
\itemize{
  \item \code{Resultados}: A data frame with pairwise comparisons, including mean differences, t-values, degrees of freedom, p-values, and significance labels.
  \item \code{Promedios}: A named numeric vector of group means.
  \item \code{Orden_Medias}: A character vector with group names ordered by their means.
  \item \code{Metodo}: A character string indicating the method used ("Games-Howell").
}
}
\description{
Performs the Games-Howell test for pairwise comparisons after ANOVA,
without assuming equal variances or sample sizes. It is suitable when
Levene or Bartlett test indicates heterogeneity of variances.
}
\details{
Advantages:
- Excellent for heteroscedastic data.
- Controls Type I error across unequal group sizes.

Disadvantages:
- Slightly conservative in small samples.
- More complex to compute than Tukey.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- GHTest(mod)
summary(resultado)
plot(resultado)
}
\references{
Games, P. A., & Howell, J. F. (1976). "Pairwise Multiple Comparison Procedures with Unequal N's and/or Variances: A Monte Carlo Study". Journal of Educational Statistics, 1(2), 113–125. <https://doi.org/10.1002/j.2162-6057.1976.tb00211.x>
}
