% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomeObject.R
\name{getNcAA}
\alias{getNcAA}
\title{Calculate the Effective Number of Codons for each Amino Acid}
\usage{
getNcAA(genome)
}
\arguments{
\item{genome}{A genome object initialized with \code{\link{initializeGenomeObject}}.}
}
\value{
Returns an object of type \code{data.frame} with the Effective Number of Codons
for each amino acid in each gene.
}
\description{
\code{getNcAA} returns the Effective Number of Codons for each Amino Acid.
}
\examples{

genome_file <- system.file("extdata", "more_genes.fasta", package = "AnaCoDa")
## reading genome
genome <- initializeGenomeObject(file = genome_file)

nc <- getNcAA(genome)

}
