% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popSummary.R
\name{ebv}
\alias{ebv}
\title{Estimated breeding value}
\usage{
ebv(pop)
}
\arguments{
\item{pop}{a \code{\link{Pop-class}} or similar object}
}
\description{
A wrapper for accessing the ebv slot
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAD(10, meanDD=0.5)
SP$setVarE(h2=0.5)

#Create population
pop = newPop(founderPop, simParam=SP)
pop@ebv = matrix(rnorm(pop@nInd), nrow=pop@nInd, ncol=1)
ebv(pop)

}
