% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/founderPop.R
\name{trackHaploPop}
\alias{trackHaploPop}
\title{Haplotype tracking population}
\usage{
trackHaploPop(genMap, nInd, inbred = FALSE)
}
\arguments{
\item{genMap}{a list of genetic maps}

\item{nInd}{number of individuals}

\item{inbred}{should individuals be fully inbred}
}
\description{
Creates a population contain haplotypes numbered for 
identity be descent tracking.
}
\details{
Each item of genMap must be a vector of ordered genetic lengths in 
Morgans. The first value must be zero. The length of the vector 
determines the number of segregating sites on the chromosome.

If inbred=FALSE, the value of nInd must be less than or equal to 
128. Otherwise, it must be less than or equal to 256.
}
\examples{
# Create genetic map for a single chromosome with 1 Morgan
# Chromosome contains 11 equally spaced segregating sites
genMap = list(seq(0,1,length.out=11))
founderPop = trackHaploPop(genMap=genMap,nInd=10)

}
