% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_setMeiosis}
\alias{SimParam_setMeiosis}
\title{Set meiosis parameters}
\arguments{
\item{v}{the crossover interference parameter for a gamma model of 
recombination. A value of 1 indicates no crossover interference 
(e.g. Haldane mapping function). A value of 2.65 approximates the 
degree of crossover interference implied by the Kosambi mapping 
function. (default is 1)}

\item{ratio}{relative ratio of recombination in females compared to 
males. A value of 2 indicate twice as much recombination in females 
and a value of 1/2 would indicate half as much recombinations. The 
value must be greater than 0. (default is 1)}

\item{quadProb}{the probability of quadrivalent pairing in an 
autopolyploid. A value of 2/3 equals the probability expected under 
random pairing of telomeres in a tetraploid. (default is 0)}

\item{force}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\description{
Changes parameters defining the amount of crossover 
interference, the gender specific recombination ratio, or the 
probability of quadrivalent pairing in autopolyploids. Parameters 
are only changed if specified by the user. The default values for the 
parameters are indicated in descriptions below.
}
\section{Usage}{
 SP$setMeiosis(v = NULL, ratio = NULL, quadProb = NULL, 
force = FALSE)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setMeiosis(ratio=2) #Twice as much recombination in females

}
