% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelic_series_sumstats.R
\name{ASBTSS}
\alias{ASBTSS}
\title{Allelic Series Burden Test from Summary Statistics}
\usage{
ASBTSS(
  anno,
  beta,
  se,
  check = TRUE,
  eps = 1,
  lambda = 1,
  ld = NULL,
  maf = NULL,
  method = "none",
  weights = DEFAULT_WEIGHTS
)
}
\arguments{
\item{anno}{(snps x 1) annotation vector with values in c(0, 1, 2).}

\item{beta}{(snps x 1) vector of effect sizes for the coding genetic variants
within a gene.}

\item{se}{(snps x 1) vector of standard errors for the effect sizes.}

\item{check}{Run input checks? Default: TRUE.}

\item{eps}{Epsilon added to the diagonal of the LD matrix if not positive
definite. Note, smaller values increase the chances of a false positive.}

\item{lambda}{Optional genomic inflation factor. Defaults to 1, which
results in no rescaling.}

\item{ld}{(snps x snps) matrix of correlations among the genetic variants.
Although ideally provided, an identity matrix is assumed if not.}

\item{maf}{(snps x 1) vector of minor allele frequencies. Although ideally
provided, defaults to the zero vector.}

\item{method}{Method for aggregating across categories:
("none", "sum"). Default: "none".}

\item{weights}{(3 x 1) vector of annotation category weights.}
}
\value{
Numeric p-value of the allelic series burden test.
}
\description{
Allelic series burden test from summary statistics.
}
\examples{
# Generate data.
data <- DGP(n = 1e3)
sumstats <- CalcSumstats(data = data)

# Run allelic series burden test from sumstats.
results <- ASBTSS(
  anno = sumstats$anno,
  beta = sumstats$sumstats$beta, 
  maf = sumstats$maf,
  se = sumstats$sumstats$se,
  ld = sumstats$ld
)
show(results)
}
