% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_externalFit.R
\name{pat_externalFit}
\alias{pat_externalFit}
\title{Linear model fitting of PurpleAir and federal PWFSL time series data}
\usage{
pat_externalFit(
  pat = NULL,
  showPlot = TRUE,
  size = 1,
  pa_color = "purple",
  pwfsl_color = "black",
  alpha = 0.5,
  lr_shape = 15,
  lr_color = "black",
  lr_lwd = 1.5,
  lr_lcolor = "tomato",
  lr_lalpha = 0.45,
  ts_shape = 1,
  xylim = NULL,
  channel = "ab",
  replaceOutliers = TRUE,
  qc_algorithm = "hourly_AB_01",
  min_count = 20
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}

\item{showPlot}{Logical specifying whether to generate a model fit plot.}

\item{size}{Size of points.}

\item{pa_color}{Color of hourly points.}

\item{pwfsl_color}{Color of hourly points.}

\item{alpha}{Opacity of points.}

\item{lr_shape}{Symbol to use for linear model points.}

\item{lr_color}{Color of linear model plot points.}

\item{lr_lwd}{Width of linear regression line.}

\item{lr_lcolor}{Color of linear regression line.}

\item{lr_lalpha}{Opacity of linear regression line.}

\item{ts_shape}{Symbol to use for time series points.}

\item{xylim}{Vector of (lo,hi) limits used as limits on the correlation plot 
axes -- useful for zooming in.}

\item{channel}{Data channel to use for PM2.5 -- one of "a", "b or "ab".}

\item{replaceOutliers}{Logical specifying whether or not to replace outliers.}

\item{qc_algorithm}{Named QC algorithm to apply to hourly aggregation stats.}

\item{min_count}{Aggregation bins with fewer than `min_count` measurements
will be marked as `NA`.}
}
\value{
A linear model, fitting the `pat` PurpleAir readings to the closest
PWFSL monitor readings.
}
\description{
Produces a linear model between data from PurpleAir and data 
from the closest PWFSL monitor.

A diagnostic plot is produced if `showPlot = TRUE`.
}
\examples{
\donttest{
library(AirSensor)

pat_externalFit(example_pat)
}
}
