% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_createPATimeseriesObject.R
\name{pat_createPATimeseriesObject}
\alias{pat_createPATimeseriesObject}
\title{Combine PurpleAir raw dataframes}
\usage{
pat_createPATimeseriesObject(pat_rawList = NULL)
}
\arguments{
\item{pat_rawList}{List of dataframes as returned by \code{pat_downloadParseRawData()}.}
}
\value{
A PurpleAir Timeseries \emph{pat} object.
}
\description{
The \code{pat_downloadParseRawData()} function returns four
dataframes of data from ThingSpeak. These must be combined into the single
\code{data} dataframe found in a 'pat' object. This process involves selecting
data columns to use and bringing all data onto a unified time axis.

Two sets of data values exist in the raw data, one for each of two algorithms
that convert particle counts into aerosol density.

PurpleAir has the following description:

\emph{
The CF_ATM and CF_1 values are calculated from the particle count data with a 
proprietary algorithm developed by the PMS5003 laser counter manufacturer, 
PlanTower. The specifics of the calculation are not available to the public 
(or us for that matter). However, to convert the particle count data (um/dl) 
to a mass concentration (ug/m3) they must use an average particle density. 
They do provide 2 different mass concentration conversion options; CF_1 uses 
the "average particle density" for indoor particulate matter and CF_ATM uses 
the "average particle density" for outdoor particulate matter.
}

The \pkg{AirSensor} package and all associated archive data use PlanTower
algorithm \code{CF_ATM}.
}
\examples{
\donttest{
library(AirSensor)

setArchiveBaseUrl("http://data.mazamascience.com/PurpleAir/v1")

pas <- pas_load()

pat_rawList <- pat_downloadParseRawData(
  id = "78df3c292c8448f7_21257",
  pas = pas
)

pat <- pat_createPATimeseriesObject(pat_rawList)

pat_multiPlot(pat)
}
}
\references{
\url{https://www2.purpleair.com/community/faq#!hc-what-is-the-difference-between-cf-1-and-cf-atm}
}
