% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_addAirDistrict.R
\name{pas_addAirDistrict}
\alias{pas_addAirDistrict}
\title{Add an air district to PurpleAir Synoptic Data}
\usage{
pas_addAirDistrict(pas = NULL)
}
\arguments{
\item{pas}{PurpleAir Synoptic \emph{pas} object.}
}
\value{
A pa_synoptic dataframe
}
\description{
Adds an air district (if any) to a pa_synoptic object via the 
\code{MazamaSpatialUtils} Package using PurpleAir location coordinates to 
determine the air basin the sensor is in.
}
\note{
As of 2020-04-14, only California air basins is supported.
}
\examples{
\donttest{
library(AirSensor)

initializeMazamaSpatialUtils()

pas_enhanced <-
  example_pas_raw \%>\% 
  pas_addSpatialMetadata() \%>\%  
  pas_addAirDistrict() 
}
}
\seealso{
\link{pas_enhanceData}
}
