% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqiCategories.R
\name{aqiCategories}
\alias{aqiCategories}
\title{Generate AQI categories}
\usage{
aqiCategories(
  x,
  pollutant = c("PM2.5", "AQI", "CO", "NO", "OZONE", "PM10", "SO2"),
  NAAQS = c("PM2.5", "PM2.5_2024"),
  conversionArray = NULL
)
}
\arguments{
\item{x}{Vector or matrix of PM2.5 values or an \emph{mts_monitor} object.}

\item{pollutant}{EPA AQS criteria pollutant.}

\item{NAAQS}{Version of NAAQS levels to use. See Note.}

\item{conversionArray}{Array of six text or other values to return instead of integers.}
}
\value{
A vector or matrix of AQI category indices in the range 1:6.
}
\description{
This function converts hourly PM2.5 measurements into AQI category levels.
These levels can then be converted to colors or names using the arrays found
in \code{\link{US_AQI}}.
}
\details{
By default, return values will be integers in the range 1:6 or \code{NA}. The
\code{conversionArray} parameter can be used to convert these integers into
whatever is specified in the first six elements of \code{conversionArray}. A
typical usage would be: \code{conversionArray = US_AQI$names_eng}.
}
\note{
On February 7, 2024, EPA strengthened the National Ambient Air Quality
Standards for Particulate Matter (PM NAAQS) to protect millions of Americans
from harmful and costly health impacts, such as heart attacks and premature
death. Particle or soot pollution is one of the most dangerous forms of air
pollution, and an extensive body of science links it to a range of serious
and sometimes deadly illnesses. EPA is setting the level of the primary
(health-based) annual PM2.5 standard at 9.0 micrograms per cubic meter to
provide increased public health protection, consistent with the available
health science.
See \href{https://www.epa.gov/pm-pollution/final-reconsideration-national-ambient-air-quality-standards-particulate-matter-pm}{PM NAAQS update}.
}
\examples{
library(AirMonitor)

# Lane County, Oregon AQSIDs all begin with "41039"
LaneCounty <-
  NW_Megafires \%>\%
  monitor_filter(stringr::str_detect(AQSID, '^41039')) \%>\%
  monitor_filterDate(20150822, 20150823)

LaneCounty \%>\%
  aqiCategories()

LaneCounty \%>\%
  aqiCategories(conversionArray = US_AQI$names_eng)
}
\seealso{
\code{\link{aqiColors}}
}
