% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/croqui_function.R
\name{sketch}
\alias{sketch}
\title{Utils: Experimental sketch}
\usage{
sketch(trat, trat1 = NULL, trat2 = NULL, r, design = "dic", pos = "line")
}
\arguments{
\item{trat}{Vector with factor A levels}

\item{trat1}{Vector with levels of factor B (Set to NULL if not factorial or psub)}

\item{trat2}{Vector with levels of factor C (Set to NULL if not factorial)}

\item{r}{Number of repetitions}

\item{design}{Experimental design ("dic", "dbc", "dql","psubdic","psubdbc","fat2dic","fat2dbc")}

\item{pos}{Repeat position (line or column)}
}
\value{
Returns an experimental sketch according to the specified design.
}
\description{
Experimental sketching function
}
\note{
The sketches have only a rectangular shape, and the blocks (in the case of randomized blocks) can be in line or in a column.
}
\examples{
Trat=paste("Tr",1:6)

#=============================
# Completely randomized design
#=============================
sketch(Trat,r=3)
sketch(Trat,r=3,pos="column")

#=============================
# Randomized block design
#=============================
sketch(Trat, r=3, design="dbc")
sketch(Trat, r=3, design="dbc",pos="column")

#=============================
# Completely randomized experiments in double factorial
#=============================
sketch(trat=c("A","B"),
       trat1=c("A","B","C"),
       design = "fat2dic",
       r=3)

sketch(trat=c("A","B"),
       trat1=c("A","B","C"),
       design = "fat2dic",
       r=3,
       pos="column")
}
\references{
Mendiburu, F., & de Mendiburu, M. F. (2019). Package ‘agricolae’. R Package, Version, 1-2.
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{croqui}
\keyword{experimental}
