% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spider_graph_function.R
\name{spider_graph}
\alias{spider_graph}
\title{Graph: Spider graph for sensorial analysis}
\usage{
spider_graph(
  resp,
  vari,
  blend,
  legend.title = "",
  xlab = "",
  ylab = "",
  ymin = 0
)
}
\arguments{
\item{resp}{Vector containing notes}

\item{vari}{Vector containing the variables}

\item{blend}{Vector containing treatments}

\item{legend.title}{Caption title}

\item{xlab}{x axis title}

\item{ylab}{y axis title}

\item{ymin}{Minimum value of y}
}
\value{
Returns a spider or radar chart. This graph is commonly used in studies of sensory analysis.
}
\description{
Spider chart or radar chart. Usually used for graphical representation of acceptability in sensory tests
}
\examples{
library(AgroR)
data(sensorial)
with(sensorial, spider_graph(resp, variable, Blend))
}
\seealso{
\link{radargraph}, \link{sk_graph}, \link{plot_TH}, \link{corgraph}, \link{barplot_positive}, \link{line_plot}
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
