% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_normplot.R
\name{summary_normplot}
\alias{summary_normplot}
\title{Plotting the Amplitude of Several Pollen Seasons.}
\usage{
summary_normplot(data, pollen, mave = 1, normalized = FALSE,
  interpolation = TRUE, int.method = "lineal", export.plot = TRUE,
  export.format = "pdf", color.plot = "orange2",
  axisname = "Pollen grains / m3", ...)
}
\arguments{
\item{data}{A \code{data.frame} object. This \code{data.frame} should include a first column in format \code{Date} and the rest of columns in format \code{numeric} belonging to each pollen type by column.}

\item{pollen}{A \code{character} string with the name of the particle to show. This \code{character} must match with the name of a column in the input database. This is a mandatory argument.}

\item{mave}{An \code{integer} value specifying the order of the moving average applied to the data. By default, \code{mave = 1}.}

\item{normalized}{A \code{logical} value specifying if the visualization shows real pollen data (\code{normalized = FALSE}) or the percentage of every day over the whole pollen season (\code{normalized = TRUE}). By default, \code{normalized = FALSE}.}

\item{interpolation}{A \code{logical} value specifying if the visualization shows the gaps in the inputs data (\code{interpolation = FALSE}) or if an interpolation method is used for filling the gaps (\code{interpolation = TRUE}). By default, \code{interpolation = TRUE}.}

\item{int.method}{A \code{character} string with the name of the interpolation method to be used. The implemented methods that may be used are: \code{"lineal"}, \code{"movingmean"}, \code{"tseries"} or \code{"spline"}. By default, \code{int.method = "lineal"}.}

\item{export.plot}{A \code{logical} value specifying if a plot will be exported or not. If \code{FALSE} graphical results will only be displayed in the active graphics window. If \code{TRUE} graphical results will be displayed in the active graphics window and also one pdf/png file will be saved within the \emph{plot_AeRobiology} directory automatically created in the working directory. By default, \code{export.plot = TRUE}.}

\item{export.format}{A \code{character} string specifying the format selected to save the plot. The implemented formats that may be used are: \code{"pdf"} or \code{"png"}. By default, \code{export.format = "pdf"}.}

\item{color.plot}{A \code{character} string. The argument defines the color to fill the plot. Will be \code{"orange2"} by default.}

\item{axisname}{A \code{character} string specifying the title of the y axis. By default, \code{axisname =  "Pollen grains / m3"}.}

\item{...}{Other additional arguments may be used to customize the exportation of the plots using \code{"pdf"} or \code{"png"} files and therefore arguments from functions \code{\link[grDevices]{pdf}} and  \code{\link[grDevices]{png}} may be implemented. For example, for pdf files the user may custom the arguments: width, height, family, title, fonts, paper, bg, fg, pointsize...; and for png files the user may custom the arguments: width, height, units, pointsize, bg, res...}
}
\value{
This function returns plot of class \pkg{ggplot2}. User are able to customize the output as a \pkg{ggplot2} object.
}
\description{
Function to plot the pollen data amplitude during several seasons: daily average pollen concentration over the study period, maximum pollen concentration of each day over the study period and minimum pollen concentration of each day value over the study period. It is possible to plot the relative abundance per day and smoothing the pollen season by calculating a moving average.
}
\examples{
data("munich")
summary_normplot(munich, pollen = "Betula", interpolation = FALSE, export.plot = FALSE)
}
\seealso{
\code{\link{calculate_ps}}; \code{\link{summary_plot}}
}
