% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singleIter.R
\name{singleIter}
\alias{singleIter}
\title{\code{singleIter()} applies a single iteraction of AdaSampling procedure. It
returns the probabilities of all samples as being a positive (P) or negative
(N) instance, as a two column data frame.}
\usage{
singleIter(Ps, Ns, dat, test = NULL, pos.probs = NULL, una.probs = NULL,
  classifier = "svm", sampleFactor, seed)
}
\arguments{
\item{Ps}{names (name as index) of positive examples}

\item{Ns}{names (name as index) of negative examples}

\item{dat}{training data matrix, without class labels.}

\item{test}{test data matrix, without class labels.
Training data matrix will be used for testing if this is NULL (default).}

\item{pos.probs}{a numeric vector of containing probability of positive examples been positive}

\item{una.probs}{a numeric vector of containing probability of negative or unannotated examples been negative}

\item{classifier}{classification algorithm to be used for learning. Current options are
support vector machine, \code{"svm"}, k-nearest neighbour, \code{"knn"}, logistic regression \code{"logit"}, or
linear discriminant analysis \code{"lda"}.}

\item{sampleFactor}{provides a control on the sample size for resampling.}

\item{seed}{sets the seed.}
}
\description{
Classification algorithms included are support vector machines (svm),
k-nearest neighbours (knn), logistic regression (logit), and linear discriminant
analysis (lda).
}
\section{References}{

Yang, P., Liu, W., Yang. J. (2017) Positive unlabeled learning via wrapper-based
adaptive sampling. \emph{International Joint Conferences on Artificial Intelligence (IJCAI)}, 3272-3279

Yang, P., Ormerod, J., Liu, W., Ma, C., Zomaya, A., Yang, J.(2018) 
AdaSampling for positive-unlabeled and label noise learning with bioinformatics applications. 
\emph{IEEE Transactions on Cybernetics}, doi:10.1109/TCYB.2018.2816984
}

