% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/night.shade.r
\name{home.night.shade}
\alias{home.night.shade}
\title{Generates home night time periods}
\usage{
home.night.shade(x, shadow.start = "20:00:00", shadow.end = "06:00:00",
  homeTZ, tz = "UTC", ...)
}
\arguments{
\item{x}{a dataframe}

\item{shadow.start}{starting time of the home night, 22:00:00 by defaults}

\item{shadow.end}{ending time of the home night, 08:00:00 by defaults}

\item{homeTZ}{participant's home time zone. A data frame containing for each participant
corresponding home time zone.}

\item{tz}{is the time zone}

\item{...}{Optional parameters}
}
\value{
a dataframe
}
\description{
This function is used by the Darwent plot
}
\examples{
library("dplyr")
library("lubridate")
data(act)
dat <- act \%>\% group_by(subject_ID) \%>\%
mutate(start = min(datime_start)) \%>\%
ungroup \%>\% filter(datime_start <= start + lubridate::days(5),
subject_ID == 1, interval_type != "ACTIVE")
homeTZ = data.frame(subject_ID = "1",
TZ = "Pacific/Auckland", stringsAsFactors = FALSE)
home.night.shade(dat, shadow.start = "20:00:00", shadow.end = "06:00:00",
homeTZ = homeTZ)
}
