% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G_matrix.R
\name{G.matrix}
\alias{G.matrix}
\title{Obtains the genomic matrix from SNP data for additive or dominant relationships}
\usage{
G.matrix(
  M = NULL,
  method = "VanRaden",
  na.string = "NA",
  sparseform = FALSE,
  digits = 8,
  message = TRUE
)
}
\arguments{
\item{M}{A matrix with SNP data of form \eqn{n \times p}, with \eqn{n} individuals and \eqn{p} markers.
Individual and marker names are assigned to \code{rownames} and \code{colnames}, respectively.
SNP data is coded as 0, 1, 2 (integers or decimal numbers) (default = \code{NULL}).}

\item{method}{The method considered for calculation of genomic matrix.
Options are: \code{"VanRaden"} and \code{"Yang"} for additive matrix,
and \code{"Su"} and \code{"Vitezica"} for dominant matrix (default =  \code{"VanRaden"}).}

\item{na.string}{A character that is interpreted as missing values (default = \code{"NA"}).}

\item{sparseform}{If \code{TRUE} it generates a matrix in sparse form to be used directly in \pkg{asreml} with
required attributes (default = \code{FALSE}).}

\item{digits}{Set up the number of digits used to round the output matrix (default = 8).}

\item{message}{If \code{TRUE} diagnostic messages are printed on screen (default = \code{TRUE}).}
}
\value{
A list with one of these two elements:
\itemize{
\item \code{G}: the \eqn{\boldsymbol{G}} matrix in full form (only if \code{sparseform = FALSE}).
\item \code{G.sparse}: the \eqn{\boldsymbol{G}} matrix in sparse form (only if \code{sparseform = TRUE}).
}
}
\description{
Generates the genomic numerator relationship matrix for
additive (VanRaden or Yang) or dominant (Su or Vitezica) relationships.
Matrix provided \eqn{\boldsymbol{M}} is of the form \eqn{n \times p}, with \eqn{n} individuals and \eqn{p} markers.
Individual and
marker names are assigned to \code{rownames} and \code{colnames}, respectively.
SNP data is coded as 0, 1, 2 (integers or decimal numbers).
Missing values, if present, need to be specified.
}
\details{
Note: If data is provided with missing values, it will process calculations
of relationships on pairwise non-missing data.

It uses function \code{Gmatrix} for calculations
from R package  \pkg{AGHmatrix} (Amadeu \emph{et al.} 2019).
}
\examples{
# Example: Requesting a full matrix by VanRanden.

# Get G matrix.
G <- G.matrix(M = geno.apple, method = "VanRaden")$G
G[1:5, 1:5]

\donttest{
# Example: Requesting a sparse form by VanRanden.

# Get G matrix.
G <- G.matrix(M = geno.apple, method = "VanRaden", sparseform = TRUE)$G.sparse
head(G)
head(attr(G, "rowNames"))
}

}
\references{
Amadeu, R.R., Cellon, C., Olmstead, J.W., Garcia, A.A.F, Resende, M.F.R. and P.R. Munoz. 2016.
AGHmatrix: R package to construct relationship matrices for autotetraploid and diploid species:
A blueberry example. The Plant Genome 9(3). doi: 10.3835/plantgenome2016.01.0009
}
