% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_logs.R
\name{clean_logs}
\alias{clean_logs}
\title{Extract log data from BAR-LT log files}
\usage{
clean_logs(log_files, return = "all", progress = TRUE)
}
\arguments{
\item{log_files}{Character vector of log files to process.}

\item{return}{Character. What kind of data to return, GPS fixes (\code{"gps"}),
recording events (\code{"recordings"}) or \code{"all"} (default).}

\item{progress}{Logical. Whether to use \code{purrr::map()} progress bars (default
\code{TRUE}).}
}
\value{
Data frame containing
\itemize{
\item \code{file_name}s and \code{path}s of the log files
\item \code{event}s and their \code{date_time}s
\item \code{lat} and \code{lon} for "gps" events
\item \code{rec_file}, \code{rec_size} and \code{rec_end} for "recording" events
(recording start is the \code{date_time} of the event)
\item \code{schedule} information such as \code{schedule_date}, \code{schedule_name},
\code{schedule_lat}, \code{schedule_lon}, \code{schedule_sr} (sunrise),
and \code{schedule_ss} (sunset)
\item \code{meta}data information such as \code{meta_serial} and \code{meta_firmware}
}
}
\description{
Process BAR-LT log files into a data frame reflecting metadata, schedule
information, and events. Events are time-stamped logs of either GPS fixes
(\code{lat} and \code{lon}) or recordings (\code{rec_file}, \code{rec_size}, \code{rec_end}).
}
\details{
Note that log files can have glitches. If there is no start time for a
recording (generally when there is a problem and no recording is made), the
\code{date_time} value for that recording will be the same as the \code{rec_end} time.

Because the BAR-LT units adjust their time according to the GPS locations,
all times are in "local" to that area.
}
\examples{
\dontshow{if (dir.exists("my_project_folder")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Replace "my_project_folder" with your directory containing your recordings and logfiles
log_files <- fs::dir_ls("my_project_folder", recurse = TRUE, glob = "*logfile*")
log_files
logs <- clean_logs(log_files)

log_files <- "../ARUtools - Extra/aru_log_files/P028/1A_BARLT10962/logfile_00010962_SD1.txt"

clean_logs(log_files)
clean_logs(log_files, return = "gps")
clean_logs(log_files, return = "recordings")

log_files <- fs::dir_ls("../ARUtools - Extra/aru_log_files/", recurse = TRUE, glob = "*logfile*")

l <- clean_logs(log_files)
\dontshow{\}) # examplesIf}
}
