% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc.indices.R
\name{assoc.indices}
\alias{assoc.indices}
\title{Association indices}
\usage{
assoc.indices(gbi, index = "sri")
}
\arguments{
\item{gbi}{a group by individual matrix.}

\item{index}{a string indicating the association index to compute:
\itemize{
\item 'sri' for Simple ratio index: \eqn{x/x+yAB+yA+yB}
\item 'hw' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
\item 'sr' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
}}
}
\value{
A square matrix of individual association indices.
}
\description{
Compute several association indices.
}
\examples{
sim.gbi
assoc.indices(gbi=sim.gbi,index='sri')
}
\references{
Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez
}
