% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.effort.R
\name{sampling.effort}
\alias{sampling.effort}
\title{Sampling effort}
\usage{
sampling.effort(
  df,
  col.time,
  cumulative = TRUE,
  metric = "met.strength",
  assoc.indices = FALSE,
  actor = NULL,
  receiver = NULL,
  sym = FALSE,
  scan = NULL,
  id = NULL,
  index = "sri",
  ...
)
}
\arguments{
\item{df}{a data frame of interactions or associations.}

\item{col.time}{an integer or string indicating the column with the time/period information}

\item{cumulative}{a bolean, if TRUE, it computes the argument metric declared for each step of periods keeping previous periods}

\item{metric}{a string to call an ANTs function of class 'met.XXX'.}

\item{assoc.indices}{a bolean, if TRUE, it creates matrices of associations according to argument 'index' and argument 'df' must be a data frame of associations, see df.to.gbi.
Otherwise, it creates  a matrix of interactions and argument 'df' must be a data frame of interactions type (see df.to.mat).}

\item{actor}{an integer or a string indicating the column of the individuals performing the behaviour. This argument must be declared if argument 'assoc.indices' is equal to FALSE.}

\item{receiver}{an integer or a string indicating the column of the individuals receiving the behaviour. This argument must be declared if argument 'assoc.indices' is equal to FALSE.}

\item{sym}{a boolean if true, interactions or associations are considered symmetric. This argument must be declared if argument 'assoc.indices' is equal to FALSE.}

\item{scan}{a numeric or character vector representing one or more columns used as scan factors. This argument must be declared if argument 'assoc.indices' is equal to FALSE.}

\item{id}{a numeric or character vector indicating the column holding ids of individuals.}

\item{index}{a string indicating the association index to compute:}

\item{...}{additional argument related to the computation of the metric declared.
\itemize{
\item 'sri' for Simple ratio index: \eqn{x/x+yAB+yA+yB}
\item 'hw' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
\item 'sr' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
}}
}
\value{
A list of two elemnts:
\itemize{
\item 'df', a data frame with metric evolution through time
\item plot a plot of the metric evolution through time
}
}
\description{
Visualize metric variation through period of observations
}
\details{
This function allows to visualize metric (nodal and global) variation through periods of observation. Studies have highlighted the need to assess their stability. 
Metric stability can be assessed by a sigmoide curve reaching a plateau. While the function doesn't give you any statistical test, it allows to visualize if the plateau is reached or not.
For this approach, argument cumulative must be set to TRUE.
}
\examples{
df <- sim.focal.directed
df$period <- rep(c("a", "b", "c", "d", "e"))
# Node measures non cumulative example 
sampling.effort(df, col.time = "period", cumulative = FALSE,
                metric = "met.strength", actor = "actor", receiver = "receiver")

# Node measures cumulative example
sampling.effort(df, col.time = "period", cumulative = TRUE,
                metric = "met.strength", actor = "actor", receiver = "receiver")

# Node measures with extra arguments example
sampling.effort(df, col.time = "period", actor = "actor",
               receiver = "receiver", metric = "met.affinity")
 
sampling.effort(df, col.time = "period", actor = "actor",
                receiver = "receiver", metric = "met.affinity", binary = TRUE)

# Example of how to test global network metric with non cumulative version
sampling.effort(df, col.time = "period", cumulative = FALSE,
                metric = "met.density", actor = "actor", receiver = "receiver")

# Example of how to test global network metric with cumulative version
sampling.effort(df, col.time = "period", cumulative = TRUE,
                metric = "met.density", actor = "actor", receiver = "receiver")

# Same example with gambit of the group data collection protocol--------
# Node measures non cumulative example
sampling.effort(sim.grp, col.time = "day", cumulative = TRUE,
                 metric = "met.strength", assoc.indices = TRUE,
                 scan = c("time", "location"), id = "ID", index = "sri")

# Node measures non cumulative example
sampling.effort(sim.grp, col.time = "day", cumulative = FALSE,
                metric = "met.strength", assoc.indices = TRUE, 
                scan = c("time", "location"), id = "ID", index = "sri" )

# Node measures with extra arguments example
sampling.effort(sim.grp, col.time = "day", cumulative = FALSE, 
                metric = "met.affinity", assoc.indices = TRUE, 
                scan = c("time", "location"), id = "ID", index = "sri")
                
sampling.effort(sim.grp, col.time = "day", cumulative = FALSE, 
                metric = "met.affinity", assoc.indices = TRUE, 
                scan = c("time", "location"), id = "ID", 
                index = "sri", binary = TRUE)

# Example of how to test global network metric with non cumulative version
sampling.effort(df = sim.grp, col.time = "day", cumulative = FALSE,
                metric = "met.density",assoc.indices = TRUE, 
                scan = c("time", "location"), id = "ID", index = "sri")

# Example of how to test global network metric with cumulative version
sampling.effort(df = sim.grp, col.time = "day", cumulative = TRUE, 
                metric = "met.density", assoc.indices = TRUE,
                scan = c("time", "location"), id = "ID", index = "sri")

}
\references{
Farine, D. R., & Strandburg-Peshkin, A. (2015). Estimating uncertainty and reliability of social network data using Bayesian inference. Royal Society open science, 2(9), 150367.
}
\author{
Sebastian Sosa
}
