% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.eigen.R
\name{met.eigen}
\alias{met.eigen}
\title{Eigenvector Centrality}
\usage{
met.eigen(M, df = NULL, dfid = NULL, sym = TRUE, binary = FALSE, out = FALSE)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{dfid}{an integer or a string indicating the column with individual ids in argument \emph{df}.}

\item{sym}{if \emph{TRUE}, then it symmetrizes the matrix. Otherwise, it calculates geodesic distances and diameter according to the directionality of the links.}

\item{binary}{a boolean, if \emph{TRUE}, it calculates the binary version of the eigenvector centrality.}

\item{out}{if \emph{TRUE}, it considers outgoing ties to compute the shortest paths.}
}
\value{
\itemize{
\item An integer vector of nodes \emph{eigenvector centrality} if argument \emph{df} is \emph{NULL}.
\item A list of integer vectors of nodes \emph{eigenvector centrality} if argument \emph{M} is a list of matrices and if argument \emph{df} is \emph{NULL}.
\item A list of arguments df with a new column for nodes \emph{eigenvector centrality} if argument\emph{df} is not \emph{NULL}. The name of the column is adapted according to arguments value \emph{binary}, \emph{sym} and \emph{out}.
\item A list of arguments df with a new column for nodes \emph{eigenvector centrality} if 1) argument \emph{df} is not \emph{NULL}, 2) argument \emph{M} is an output from ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk} for multiple matrices permutations, and 3) argument \emph{df} is a list of data frames of same length as argument \emph{M}.The name of the column of each element of the list is adapted according to argument value \emph{binary}.
}
}
\description{
Calculates the node metric met.evcent centrality for all vertices.
}
\details{
Eigenvector centrality is the first non-negative met.evcent value obtained through the linear transformation of an adjacency matrix. This centrality measure quantifies not only a node connectedness, but also the connections of the nodes to whom it is connected. Thus, a node can have a high met.evcent value by having a high met.degree or met.strength, or by being connected to nodes that have high degrees or strengths.
}
\examples{
met.eigen(sim.m)
head(sim.df)
met.eigen(sim.m,df=sim.df)
}
\references{
Bonacich, P. (1972). Factoring and weighting approaches to status scores and clique identification. Journal of mathematical sociology, 2(1), 113-120.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
