% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conover.R
\name{conover}
\alias{conover}
\title{Perform Conover test using standard or squared ranks}
\usage{
conover(
  x,
  y,
  H0 = NULL,
  alternative = c("two.sided", "less", "greater"),
  abs.ranks = FALSE,
  max.exact.perms = 5e+06,
  nsims.mc = 10000,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE,
  do.mc = FALSE
)
}
\arguments{
\item{x}{Numeric vector of same length as y}

\item{y}{Factor of same length as x}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{abs.ranks}{Boolean indicating whether absolute ranks to be used instead of squared ranks (defaults to \code{FALSE})}

\item{max.exact.perms}{Maximum number of permutations allowed for exact calculations (defaults to \code{5000000})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{10000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{FALSE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{conover()} performs the Conover test using standard or squared ranks and is used in chapters 6 and 7 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 6.13 from "Applied Nonparametric Statistical Methods" (5th edition)
conover(ch6$typeA, ch6$typeB, do.exact = FALSE, do.asymp = TRUE)

# Exercise 7.15 from "Applied Nonparametric Statistical Methods" (5th edition)
conover(ch7$braking.distance.2, ch7$initial.speed, do.exact = FALSE, do.asymp = TRUE)

}
