% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.median.R
\name{control.median}
\alias{control.median}
\title{Perform Control median test}
\usage{
control.median(
  x,
  y,
  H0 = NULL,
  alternative = c("two.sided", "less", "greater"),
  CI.width = 0.95,
  max.exact.cases = 1000,
  nsims.mc = 10000,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE,
  do.CI = TRUE
)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{CI.width}{Confidence interval width (defaults to \code{0.95})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{1000})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{10000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.CI}{Boolean indicating whether or not to perform confidence interval calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{control.median()} performs the Control median test and is used in chapters 6 and 9 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 6.9 from "Applied Nonparametric Statistical Methods" (5th edition)
control.median(ch6$sampleI, ch6$sampleII, alternative = "greater")

# Exercise 9.8 from "Applied Nonparametric Statistical Methods" (5th edition)
control.median(ch9$bulbA, ch9$bulbB, alternative = "greater", nsims = 1000)

}
